/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1OctetString;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.RecipientIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.AuthAttributesProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSEnvelopedHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSecureReadable;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSTypedStream;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSUtils;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.KeyTransRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.KeyTransRecipientId;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.Recipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.RecipientInformation;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.RecipientOperator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JceKeyTransAuthenticatedRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JceKeyTransRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        try {
            JceKeyTransRecipient jceKeyTransRecipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKeyTransEnvelopedRecipient((PrivateKey)key) : new JceKeyTransAuthenticatedRecipient((PrivateKey)key);
            if (provider != null) {
                jceKeyTransRecipient.setProvider(provider);
                if (provider.getName().equalsIgnoreCase("SunJCE")) {
                    jceKeyTransRecipient.setContentProvider((String)null);
                }
            }
            return this.getContentStream(jceKeyTransRecipient);
        }
        catch (IOException iOException) {
            throw new CMSException("encoding error: " + iOException.getMessage(), iOException);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

