/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Encodable;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.AuthAttributesProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSAlgorithm;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSEnvelopedHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSPBEKey;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSecureReadable;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSTypedStream;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSUtils;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.PKCS5Scheme2UTF8PBEKey;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.PasswordRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.PasswordRecipientId;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.Recipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.RecipientInformation;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.RecipientOperator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JceAlgorithmIdentifierConverter;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JcePasswordAuthenticatedRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JcePasswordEnvelopedRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JcePasswordRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.PBEParametersGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.KeyParameter;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;

public class PasswordRecipientInformation
extends RecipientInformation {
    static Map KEYSIZES = new HashMap();
    static Map BLOCKSIZES = new HashMap();
    private PasswordRecipientInfo info;

    PasswordRecipientInformation(PasswordRecipientInfo passwordRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(passwordRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = passwordRecipientInfo;
        this.rid = new PasswordRecipientId();
    }

    public String getKeyDerivationAlgOID() {
        if (this.info.getKeyDerivationAlgorithm() != null) {
            return this.info.getKeyDerivationAlgorithm().getAlgorithm().getId();
        }
        return null;
    }

    public byte[] getKeyDerivationAlgParams() {
        try {
            ASN1Encodable aSN1Encodable;
            if (this.info.getKeyDerivationAlgorithm() != null && (aSN1Encodable = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                return aSN1Encodable.toASN1Primitive().getEncoded();
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmIdentifier getKeyDerivationAlgorithm() {
        return this.info.getKeyDerivationAlgorithm();
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(String string) throws NoSuchProviderException {
        return this.getKeyDerivationAlgParameters(CMSUtils.getProvider(string));
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(Provider provider) {
        try {
            return new JceAlgorithmIdentifierConverter().setProvider(provider).getAlgorithmParameters(this.info.getKeyDerivationAlgorithm());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        try {
            CMSPBEKey cMSPBEKey = (CMSPBEKey)key;
            JcePasswordRecipient jcePasswordRecipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JcePasswordEnvelopedRecipient(cMSPBEKey.getPassword()) : new JcePasswordAuthenticatedRecipient(cMSPBEKey.getPassword());
            jcePasswordRecipient.setPasswordConversionScheme(cMSPBEKey instanceof PKCS5Scheme2UTF8PBEKey ? 1 : 0);
            if (provider != null) {
                jcePasswordRecipient.setProvider(provider);
            }
            return this.getContentStream(jcePasswordRecipient);
        }
        catch (IOException iOException) {
            throw new CMSException("encoding error: " + iOException.getMessage(), iOException);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        PasswordRecipient passwordRecipient = (PasswordRecipient)recipient;
        AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(this.info.getKeyEncryptionAlgorithm());
        AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(algorithmIdentifier.getParameters());
        byte[] byArray = this.getPasswordBytes(passwordRecipient.getPasswordConversionScheme(), passwordRecipient.getPassword());
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(this.info.getKeyDerivationAlgorithm().getParameters());
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(byArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
        int n = (Integer)KEYSIZES.get(algorithmIdentifier2.getAlgorithm());
        byte[] byArray2 = ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n)).getKey();
        return passwordRecipient.getRecipientOperator(algorithmIdentifier2, this.messageAlgorithm, byArray2, this.info.getEncryptedKey().getOctets());
    }

    protected byte[] getPasswordBytes(int n, char[] cArray) {
        if (n == 0) {
            return PBEParametersGenerator.PKCS5PasswordToBytes(cArray);
        }
        return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(cArray);
    }

    static {
        BLOCKSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(8));
        BLOCKSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(16));
        KEYSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(256));
    }
}

