/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.cert.X509CertificateHolder;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.SignerInformationVerifier;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestCalculatorProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorCreationException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;

public class BcRSASignerInfoVerifierBuilder {
    private BcRSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcRSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgIdFinder = signatureAlgorithmIdentifierFinder;
        this.contentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder(digestAlgorithmIdentifierFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(x509CertificateHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(asymmetricKeyParameter), this.digestCalculatorProvider);
    }
}

