/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.KEKRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import java.security.Key;
import java.security.Provider;
import javax.crypto.SecretKey;

public abstract class JceKEKRecipient
implements KEKRecipient {
    private SecretKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;

    public JceKEKRecipient(SecretKey secretKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.recipientKey = secretKey;
    }

    public JceKEKRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKEKRecipient setProvider(String string) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    public JceKEKRecipient setContentProvider(Provider provider) {
        this.contentHelper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKEKRecipient setContentProvider(String string) {
        this.contentHelper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        SymmetricKeyUnwrapper symmetricKeyUnwrapper = this.helper.createSymmetricUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            return this.helper.getJceKey(algorithmIdentifier2.getAlgorithm(), symmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

