/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.crypto.generators;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.KeyGenerationParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ECDomainParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.math.ec.ECConstants;
import com.geoxp.oss.jarjar.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        while ((bigInteger = new BigInteger(n, this.random)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        ECPoint eCPoint = this.params.getG().multiply(bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }
}

