/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.CryptoException;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.Certificate;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsClientContext;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsDSSSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsECDSASigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsRSASigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import java.io.IOException;

public class DefaultTlsSignerCredentials
implements TlsSignerCredentials {
    protected TlsClientContext context;
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected TlsSigner clientSigner;

    public DefaultTlsSignerCredentials(TlsClientContext tlsClientContext, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (certificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            this.clientSigner = new TlsRSASigner();
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            this.clientSigner = new TlsDSSSigner();
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.clientSigner = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.context = tlsClientContext;
        this.clientCert = certificate;
        this.clientPrivateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.clientCert;
    }

    public byte[] generateCertificateSignature(byte[] byArray) throws IOException {
        try {
            return this.clientSigner.calculateRawSignature(this.context.getSecureRandom(), this.clientPrivateKey, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80);
        }
    }
}

