/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.InvalidCipherTextException;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsClientContext;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.OutputStream;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsClientContext tlsClientContext, RSAKeyParameters rSAKeyParameters, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[48];
        tlsClientContext.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(tlsClientContext.getClientVersion(), byArray, 0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
        pKCS1Encoding.init(true, new ParametersWithRandom(rSAKeyParameters, tlsClientContext.getSecureRandom()));
        try {
            boolean bl = tlsClientContext.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            if (bl) {
                TlsUtils.writeOpaque16(byArray2, outputStream);
            } else {
                outputStream.write(byArray2);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80);
        }
        return byArray;
    }
}

