/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.CipherKeyGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA1Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.macs.HMac;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.jce.provider.JCEMac;

public class SHA1 {

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA1Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new SHA1Digest((SHA1Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new SHA1Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA1", 160, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA1.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA-1", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA1", "SHA-1");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA", "SHA-1");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + OIWObjectIdentifiers.idSHA1, "SHA-1");
            this.addHMACAlgorithm(configurableProvider, "SHA1", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "SHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
            this.addHMACAlias(configurableProvider, "SHA1", IANAObjectIdentifiers.hmacSHA1);
        }
    }
}

