/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPLiteralData;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.StreamGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.WrappedGeneratorStream;
import com.geoxp.oss.jarjar.org.bouncycastle.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class PGPLiteralDataGenerator
implements StreamGenerator {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private BCPGOutputStream pkOut;
    private boolean oldFormat = false;

    public PGPLiteralDataGenerator() {
    }

    public PGPLiteralDataGenerator(boolean bl) {
        this.oldFormat = bl;
    }

    private void writeHeader(OutputStream outputStream, char c, byte[] byArray, long l) throws IOException {
        outputStream.write(c);
        outputStream.write((byte)byArray.length);
        for (int i = 0; i != byArray.length; ++i) {
            outputStream.write(byArray[i]);
        }
        long l2 = l / 1000L;
        outputStream.write((byte)(l2 >> 24));
        outputStream.write((byte)(l2 >> 16));
        outputStream.write((byte)(l2 >> 8));
        outputStream.write((byte)l2);
    }

    public OutputStream open(OutputStream outputStream, char c, String string, long l, Date date) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        byte[] byArray = Strings.toUTF8ByteArray(string);
        this.pkOut = new BCPGOutputStream(outputStream, 11, l + 2L + (long)byArray.length + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, c, byArray, date.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream outputStream, char c, String string, Date date, byte[] byArray) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(outputStream, 11, byArray);
        byte[] byArray2 = Strings.toUTF8ByteArray(string);
        this.writeHeader(this.pkOut, c, byArray2, date.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream outputStream, char c, File file) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        byte[] byArray = Strings.toUTF8ByteArray(file.getName());
        this.pkOut = new BCPGOutputStream(outputStream, 11, file.length() + 2L + (long)byArray.length + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, c, byArray, file.lastModified());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public void close() throws IOException {
        if (this.pkOut != null) {
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }
}

