/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.DSASecretBCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.PublicKeyPacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.RSASecretBCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPUtil;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;

public class PGPPrivateKey {
    private long keyID;
    private PrivateKey privateKey;
    private PublicKeyPacket publicKeyPacket;
    private BCPGKey privateKeyDataPacket;

    public PGPPrivateKey(PrivateKey privateKey, long l) {
        this.privateKey = privateKey;
        this.keyID = l;
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            this.privateKeyDataPacket = new RSASecretBCPGKey(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ());
        } else if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            this.privateKeyDataPacket = new DSASecretBCPGKey(dSAPrivateKey.getX());
        } else if (privateKey instanceof ElGamalPrivateKey) {
            ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)privateKey;
            this.privateKeyDataPacket = new ElGamalSecretBCPGKey(elGamalPrivateKey.getX());
        } else {
            throw new IllegalArgumentException("unknown key class");
        }
    }

    public PGPPrivateKey(long l, PublicKeyPacket publicKeyPacket, BCPGKey bCPGKey) {
        this.keyID = l;
        this.publicKeyPacket = publicKeyPacket;
        this.privateKeyDataPacket = bCPGKey;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public PrivateKey getKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        try {
            return new JcaPGPKeyConverter().setProvider(PGPUtil.getDefaultProvider()).getPrivateKey(this);
        }
        catch (PGPException pGPException) {
            throw new IllegalStateException("unable to convert key: " + pGPException.toString());
        }
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicKeyPacket;
    }

    public BCPGKey getPrivateKeyDataPacket() {
        return this.privateKeyDataPacket;
    }
}

