/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGInputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.PublicKeyPacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.TrustPacket;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPKeyRing;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PGPPublicKeyRing
extends PGPKeyRing {
    List keys;

    public PGPPublicKeyRing(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
    }

    public PGPPublicKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    PGPPublicKeyRing(List list) {
        this.keys = list;
    }

    public PGPPublicKeyRing(InputStream inputStream) throws IOException {
        this(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
    }

    public PGPPublicKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream bCPGInputStream = PGPPublicKeyRing.wrap(inputStream);
        int n = bCPGInputStream.nextPacketTag();
        if (n != 6 && n != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(n));
        }
        PublicKeyPacket publicKeyPacket = (PublicKeyPacket)bCPGInputStream.readPacket();
        TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPPublicKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        try {
            this.keys.add(new PGPPublicKey(publicKeyPacket, trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator));
            while (bCPGInputStream.nextPacketTag() == 14) {
                this.keys.add(PGPPublicKeyRing.readSubkey(bCPGInputStream, keyFingerPrintCalculator));
            }
        }
        catch (PGPException pGPException) {
            throw new IOException("processing exception: " + pGPException.toString());
        }
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public Iterator getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            pGPPublicKey.encode(outputStream);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPPublicKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(i);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPPublicKey);
            }
            if (!pGPPublicKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPPublicKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPPublicKey);
            } else {
                arrayList.add(pGPPublicKey);
            }
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList arrayList = new ArrayList(pGPPublicKeyRing.keys);
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(i);
            if (pGPPublicKey2.getKeyID() != pGPPublicKey.getKeyID()) continue;
            bl = true;
            arrayList.remove(i);
        }
        if (!bl) {
            return null;
        }
        return new PGPPublicKeyRing(arrayList);
    }

    static PGPPublicKey readSubkey(BCPGInputStream bCPGInputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        PublicKeyPacket publicKeyPacket = (PublicKeyPacket)bCPGInputStream.readPacket();
        TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
        return new PGPPublicKey(publicKeyPacket, trustPacket, list, keyFingerPrintCalculator);
    }
}

