/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.MPInteger;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.OnePassSignaturePacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.SignaturePacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.SignatureSubpacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.UserAttributeSubpacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.sig.IssuerKeyID;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.sig.SignatureCreationTime;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPOnePassSignature;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPrivateKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSignature;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPUtil;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Date;

public class PGPSignatureGenerator {
    private SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    private SignatureSubpacket[] hashed = new SignatureSubpacket[0];
    private OutputStream sigOut;
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int sigType;
    private byte lastb;
    private int providedKeyAlgorithm = -1;

    public PGPSignatureGenerator(int n, int n2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(n, string, n2, string);
    }

    public PGPSignatureGenerator(int n, int n2, Provider provider) throws NoSuchAlgorithmException, PGPException {
        this(n, provider, n2, provider);
    }

    public PGPSignatureGenerator(int n, String string, int n2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(n, PGPUtil.getProvider(string), n2, PGPUtil.getProvider(string2));
    }

    public PGPSignatureGenerator(int n, Provider provider, int n2, Provider provider2) throws NoSuchAlgorithmException, PGPException {
        this.providedKeyAlgorithm = n;
        this.contentSignerBuilder = new JcaPGPContentSignerBuilder(n, n2).setProvider(provider).setDigestProvider(provider2);
    }

    public PGPSignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder) {
        this.contentSignerBuilder = pGPContentSignerBuilder;
    }

    public void initSign(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(n, pGPPrivateKey);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void init(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(n, pGPPrivateKey);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void initSign(int n, PGPPrivateKey pGPPrivateKey, SecureRandom secureRandom) throws PGPException {
        this.initSign(n, pGPPrivateKey);
    }

    public void update(byte by) throws SignatureException {
        if (this.sigType == 1) {
            if (by == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(by);
            }
            this.lastb = by;
        } else {
            this.byteUpdate(by);
        }
    }

    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.sigType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.blockUpdate(byArray, n, n2);
        }
    }

    private void byteUpdate(byte by) throws SignatureException {
        try {
            this.sigOut.write(by);
        }
        catch (IOException iOException) {
            throw new SignatureException(iOException.getMessage());
        }
    }

    private void blockUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            this.sigOut.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        byte[] byArray;
        Object object;
        int n = 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignatureSubpacket[] signatureSubpacketArray = !this.packetPresent(this.hashed, 2) ? this.insertSubpacket(this.hashed, new SignatureCreationTime(false, new Date())) : this.hashed;
        SignatureSubpacket[] signatureSubpacketArray2 = !this.packetPresent(this.hashed, 16) && !this.packetPresent(this.unhashed, 16) ? this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.contentSigner.getKeyID())) : this.unhashed;
        try {
            byteArrayOutputStream.write((byte)n);
            byteArrayOutputStream.write((byte)this.sigType);
            byteArrayOutputStream.write((byte)this.contentSigner.getKeyAlgorithm());
            byteArrayOutputStream.write((byte)this.contentSigner.getHashAlgorithm());
            object = new ByteArrayOutputStream();
            for (int i = 0; i != signatureSubpacketArray.length; ++i) {
                signatureSubpacketArray[i].encode((OutputStream)object);
            }
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            byteArrayOutputStream.write((byte)(byArray.length >> 8));
            byteArrayOutputStream.write((byte)byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding hashed data.", iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.write((byte)n);
        byteArrayOutputStream.write(-1);
        byteArrayOutputStream.write((byte)(((Object)object).length >> 24));
        byteArrayOutputStream.write((byte)(((Object)object).length >> 16));
        byteArrayOutputStream.write((byte)(((Object)object).length >> 8));
        byteArrayOutputStream.write((byte)((Object)object).length);
        byArray = byteArrayOutputStream.toByteArray();
        this.blockUpdate(byArray, 0, byArray.length);
        MPInteger[] mPIntegerArray = this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))} : PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        byte[] byArray2 = this.contentSigner.getDigest();
        byte[] byArray3 = new byte[]{byArray2[0], byArray2[1]};
        return new PGPSignature(new SignaturePacket(this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), signatureSubpacketArray, signatureSubpacketArray2, byArray3, mPIntegerArray));
    }

    public PGPSignature generateCertification(String string, PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, Strings.toUTF8ByteArray(string));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            UserAttributeSubpacket[] userAttributeSubpacketArray = pGPUserAttributeSubpacketVector.toSubpacketArray();
            for (int i = 0; i != userAttributeSubpacketArray.length; ++i) {
                userAttributeSubpacketArray[i].encode(byteArrayOutputStream);
            }
            this.updateWithIdData(209, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PGPException("cannot encode subpacket array", iOException);
        }
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithPublicKey(pGPPublicKey2);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        return this.generate();
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        return byArray;
    }

    private boolean packetPresent(SignatureSubpacket[] signatureSubpacketArray, int n) {
        for (int i = 0; i != signatureSubpacketArray.length; ++i) {
            if (signatureSubpacketArray[i].getType() != n) continue;
            return true;
        }
        return false;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket signatureSubpacket) {
        SignatureSubpacket[] signatureSubpacketArray2 = new SignatureSubpacket[signatureSubpacketArray.length + 1];
        signatureSubpacketArray2[0] = signatureSubpacket;
        System.arraycopy(signatureSubpacketArray, 0, signatureSubpacketArray2, 1, signatureSubpacketArray.length);
        return signatureSubpacketArray2;
    }

    private void updateWithIdData(int n, byte[] byArray) throws SignatureException {
        this.update((byte)n);
        this.update((byte)(byArray.length >> 24));
        this.update((byte)(byArray.length >> 16));
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }

    private void updateWithPublicKey(PGPPublicKey pGPPublicKey) throws PGPException, SignatureException {
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }
}

