/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.examples;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.ArmoredOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.sig.NotationData;
import com.geoxp.oss.jarjar.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPrivateKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKeyRing;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSecretKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSecretKeyRing;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSignature;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSignatureGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPUtil;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Security;
import java.util.Iterator;

public class DirectKeySignature {
    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray.length == 1) {
            PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
            Iterator iterator = pGPPublicKey.getSignaturesOfType(31);
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = (PGPSignature)iterator.next();
                System.out.println("Signature date is: " + pGPSignature.getHashedSubPackets().getSignatureCreationTime());
                NotationData[] notationDataArray = pGPSignature.getHashedSubPackets().getNotationDataOccurences();
                for (int i = 0; i < notationDataArray.length; ++i) {
                    System.out.println("Found Notaion named '" + notationDataArray[i].getNotationName() + "' with content '" + notationDataArray[i].getNotationValue() + "'.");
                }
            }
        } else if (stringArray.length == 5) {
            PGPPublicKeyRing pGPPublicKeyRing;
            PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String string = stringArray[1];
            PGPPublicKeyRing pGPPublicKeyRing2 = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[2])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String string2 = stringArray[3];
            String string3 = stringArray[4];
            pGPPublicKeyRing2 = pGPPublicKeyRing = new PGPPublicKeyRing(new ByteArrayInputStream(DirectKeySignature.signPublicKey(pGPSecretKeyRing.getSecretKey(), string, pGPPublicKeyRing2.getPublicKey(), string2, string3, true)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(new FileOutputStream("SignedKey.asc"));
            pGPPublicKeyRing.encode(armoredOutputStream);
            armoredOutputStream.flush();
            armoredOutputStream.close();
        } else {
            System.err.println("usage: DirectKeySignature secretKeyFile secretKeyPass publicKeyFile(key to be signed) NotationName NotationValue");
            System.err.println("or: DirectKeySignature signedPublicKeyFile");
        }
    }

    private static byte[] signPublicKey(PGPSecretKey pGPSecretKey, String string, PGPPublicKey pGPPublicKey, String string2, String string3, boolean bl) throws Exception {
        OutputStream outputStream = new ByteArrayOutputStream();
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(string.toCharArray()));
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pGPSecretKey.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
        pGPSignatureGenerator.init(31, pGPPrivateKey);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
        pGPSignatureGenerator.generateOnePassVersion(false).encode(bCPGOutputStream);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        boolean bl2 = true;
        pGPSignatureSubpacketGenerator.setNotationData(true, bl2, string2, string3);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
        bCPGOutputStream.flush();
        if (bl) {
            outputStream.close();
        }
        return PGPPublicKey.addCertification(pGPPublicKey, pGPSignatureGenerator.generate()).getEncoded();
    }
}

