/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Signer;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.MD2Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.MD5Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA1Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA224Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA256Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA384Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA512Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.TigerDigest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.AESEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.BlowfishEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.CAST5Engine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.DESEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.DESedeEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.ElGamalEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.TwofishEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.signers.DSADigestSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.signers.DSASigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;

class BcImplProvider {
    BcImplProvider() {
    }

    static Digest createDigest(int n) throws PGPException {
        switch (n) {
            case 2: {
                return new SHA1Digest();
            }
            case 11: {
                return new SHA224Digest();
            }
            case 8: {
                return new SHA256Digest();
            }
            case 9: {
                return new SHA384Digest();
            }
            case 10: {
                return new SHA512Digest();
            }
            case 5: {
                return new MD2Digest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 3: {
                return new RIPEMD160Digest();
            }
            case 6: {
                return new TigerDigest();
            }
        }
        throw new PGPException("cannot recognise digest");
    }

    static Signer createSigner(int n, int n2) throws PGPException {
        switch (n) {
            case 1: 
            case 3: {
                return new RSADigestSigner(BcImplProvider.createDigest(n2));
            }
            case 17: {
                return new DSADigestSigner(new DSASigner(), BcImplProvider.createDigest(n2));
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm");
    }

    static BlockCipher createBlockCipher(int n) throws PGPException {
        BlockCipher blockCipher;
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                blockCipher = new AESEngine();
                break;
            }
            case 4: {
                blockCipher = new BlowfishEngine();
                break;
            }
            case 3: {
                blockCipher = new CAST5Engine();
                break;
            }
            case 6: {
                blockCipher = new DESEngine();
                break;
            }
            case 10: {
                blockCipher = new TwofishEngine();
                break;
            }
            case 2: {
                blockCipher = new DESedeEngine();
                break;
            }
            default: {
                throw new PGPException("cannot recognise cipher");
            }
        }
        return blockCipher;
    }

    static AsymmetricBlockCipher createPublicKeyCipher(int n) throws PGPException {
        PKCS1Encoding pKCS1Encoding;
        switch (n) {
            case 1: 
            case 2: {
                pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
                break;
            }
            case 16: 
            case 20: {
                pKCS1Encoding = new PKCS1Encoding(new ElGamalEngine());
                break;
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + n);
            }
        }
        return pKCS1Encoding;
    }
}

