/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BufferedBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.InvalidCipherTextException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcUtil;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import java.security.SecureRandom;

public class BcPBESecretKeyEncryptorBuilder {
    private int encAlgorithm;
    private PGPDigestCalculator s2kDigestCalculator;
    private SecureRandom random;

    public BcPBESecretKeyEncryptorBuilder(int n) {
        this(n, new SHA1PGPDigestCalculator());
    }

    public BcPBESecretKeyEncryptorBuilder(int n, PGPDigestCalculator pGPDigestCalculator) {
        this.encAlgorithm = n;
        this.s2kDigestCalculator = pGPDigestCalculator;
    }

    public BcPBESecretKeyEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PBESecretKeyEncryptor build(char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return new PBESecretKeyEncryptor(this.encAlgorithm, this.s2kDigestCalculator, this.random, cArray){
            private byte[] iv;

            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                try {
                    if (this.random == null) {
                        this.random = new SecureRandom();
                    }
                    BlockCipher blockCipher = BcImplProvider.createBlockCipher(this.encAlgorithm);
                    this.iv = new byte[blockCipher.getBlockSize()];
                    this.random.nextBytes(this.iv);
                    BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(true, blockCipher, byArray, this.iv);
                    byte[] byArray3 = new byte[n2];
                    int n3 = bufferedBlockCipher.processBytes(byArray2, n, n2, byArray3, 0);
                    n3 += bufferedBlockCipher.doFinal(byArray3, n3);
                    return byArray3;
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("decryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

