/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.InvalidCipherTextException;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPrivateKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcUtil;
import java.math.BigInteger;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private PGPPrivateKey privKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        this.privKey = pGPPrivateKey;
    }

    public byte[] recoverSessionData(int n, BigInteger[] bigIntegerArray) throws PGPException {
        try {
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(n);
            AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPrivateKey(this.privKey);
            BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = new BufferedAsymmetricBlockCipher(asymmetricBlockCipher);
            bufferedAsymmetricBlockCipher.init(false, asymmetricKeyParameter);
            if (n == 2 || n == 1) {
                byte[] byArray = bigIntegerArray[0].toByteArray();
                if (byArray[0] == 0) {
                    bufferedAsymmetricBlockCipher.processBytes(byArray, 1, byArray.length - 1);
                } else {
                    bufferedAsymmetricBlockCipher.processBytes(byArray, 0, byArray.length);
                }
            } else {
                BcPGPKeyConverter bcPGPKeyConverter = new BcPGPKeyConverter();
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)bcPGPKeyConverter.getPrivateKey(this.privKey);
                int n2 = (elGamalPrivateKeyParameters.getParameters().getP().bitLength() + 7) / 8;
                byte[] byArray = new byte[n2];
                byte[] byArray2 = bigIntegerArray[0].toByteArray();
                if (byArray2.length > n2) {
                    bufferedAsymmetricBlockCipher.processBytes(byArray2, 1, byArray2.length - 1);
                } else {
                    System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
                    bufferedAsymmetricBlockCipher.processBytes(byArray, 0, byArray.length);
                }
                byArray2 = bigIntegerArray[1].toByteArray();
                for (int i = 0; i != byArray.length; ++i) {
                    byArray[i] = 0;
                }
                if (byArray2.length > n2) {
                    bufferedAsymmetricBlockCipher.processBytes(byArray2, 1, byArray2.length - 1);
                } else {
                    System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
                    bufferedAsymmetricBlockCipher.processBytes(byArray, 0, byArray.length);
                }
            }
            return bufferedAsymmetricBlockCipher.doFinal();
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception encrypting session info: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }
}

