/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.InvalidCipherTextException;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import java.security.SecureRandom;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPublicKey(pGPPublicKey);
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception encrypting session info: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }
}

