/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BufferedBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.io.CipherInputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.modes.CFBBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.KeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ParametersWithIV;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import java.io.InputStream;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean bl, BlockCipher blockCipher, boolean bl2, byte[] byArray) {
        BufferedBlockCipher bufferedBlockCipher = bl2 ? new BufferedBlockCipher(new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8)) : new BufferedBlockCipher(new OpenPGPCFBBlockCipher(blockCipher));
        KeyParameter keyParameter = new KeyParameter(byArray);
        if (bl2) {
            bufferedBlockCipher.init(bl, new ParametersWithIV(keyParameter, new byte[blockCipher.getBlockSize()]));
        } else {
            bufferedBlockCipher.init(bl, keyParameter);
        }
        return bufferedBlockCipher;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean bl, BlockCipher blockCipher, byte[] byArray) {
        final BufferedBlockCipher bufferedBlockCipher = BcUtil.createStreamCipher(false, blockCipher, bl, byArray);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, bufferedBlockCipher);
            }

            public int getBlockSize() {
                return bufferedBlockCipher.getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2) {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8));
        bufferedBlockCipher.init(bl, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        return bufferedBlockCipher;
    }
}

