/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.MPInteger;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.PublicKeyPacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JcaKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    public byte[] calculateFingerprint(PublicKeyPacket publicKeyPacket) throws PGPException {
        BCPGKey bCPGKey = publicKeyPacket.getKey();
        if (publicKeyPacket.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = new MPInteger(rSAPublicBCPGKey.getModulus()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                byArray = new MPInteger(rSAPublicBCPGKey.getPublicExponent()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                return messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PGPException("can't find MD5", noSuchAlgorithmException);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        }
        try {
            byte[] byArray = publicKeyPacket.getEncodedContents();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update((byte)-103);
            messageDigest.update((byte)(byArray.length >> 8));
            messageDigest.update((byte)byArray.length);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("can't find SHA1", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
        }
    }
}

