/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Signer;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.util.PublicKeyFactory;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorCreationException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.bc.BcUtil;
import java.io.IOException;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        Digest digest = BcUtil.createDigest(algorithmIdentifier2);
        return new RSADigestSigner(digest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

