/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.pkcs.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Encodable;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.CipherParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.ExtendedDigest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.DESedeEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.RC2Engine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.io.MacOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.macs.HMac;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.paddings.PKCS7Padding;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.DESedeParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.KeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ParametersWithIV;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.GenericKey;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.MacCalculator;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PKCS12PBEUtils {
    private static Map keySizes = new HashMap();
    private static Set noIvAlgs = new HashSet();
    private static Set desAlgs = new HashSet();

    PKCS12PBEUtils() {
    }

    static int getKeySize(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (Integer)keySizes.get(aSN1ObjectIdentifier);
    }

    static boolean hasNoIv(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return noIvAlgs.contains(aSN1ObjectIdentifier);
    }

    static boolean isDesAlg(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return desAlgs.contains(aSN1ObjectIdentifier);
    }

    static PaddedBufferedBlockCipher getEngine(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        BlockCipher blockCipher;
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC) || aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            blockCipher = new DESedeEngine();
        } else if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC) || aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC)) {
            blockCipher = new RC2Engine();
        } else {
            throw new IllegalStateException("unknown algorithm");
        }
        return new PaddedBufferedBlockCipher(new CBCBlockCipher(blockCipher), new PKCS7Padding());
    }

    static MacCalculator createMacCalculator(final ASN1ObjectIdentifier aSN1ObjectIdentifier, ExtendedDigest extendedDigest, final PKCS12PBEParams pKCS12PBEParams, final char[] cArray) {
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(extendedDigest);
        pKCS12ParametersGenerator.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray), pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
        KeyParameter keyParameter = (KeyParameter)pKCS12ParametersGenerator.generateDerivedMacParameters(extendedDigest.getDigestSize() * 8);
        final HMac hMac = new HMac(extendedDigest);
        hMac.init(keyParameter);
        return new MacCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(aSN1ObjectIdentifier, (ASN1Encodable)pKCS12PBEParams);
            }

            public OutputStream getOutputStream() {
                return new MacOutputStream(hMac);
            }

            public byte[] getMac() {
                byte[] byArray = new byte[hMac.getMacSize()];
                hMac.doFinal(byArray, 0);
                return byArray;
            }

            public GenericKey getKey() {
                return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
            }
        };
    }

    static CipherParameters createCipherParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, ExtendedDigest extendedDigest, int n, PKCS12PBEParams pKCS12PBEParams, char[] cArray) {
        CipherParameters cipherParameters;
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(extendedDigest);
        pKCS12ParametersGenerator.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray), pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
        if (PKCS12PBEUtils.hasNoIv(aSN1ObjectIdentifier)) {
            cipherParameters = pKCS12ParametersGenerator.generateDerivedParameters(PKCS12PBEUtils.getKeySize(aSN1ObjectIdentifier));
        } else {
            cipherParameters = pKCS12ParametersGenerator.generateDerivedParameters(PKCS12PBEUtils.getKeySize(aSN1ObjectIdentifier), n * 8);
            if (PKCS12PBEUtils.isDesAlg(aSN1ObjectIdentifier)) {
                DESedeParameters.setOddParity(((KeyParameter)((ParametersWithIV)cipherParameters).getParameters()).getKey());
            }
        }
        return cipherParameters;
    }

    static {
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4, new Integer(128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4, new Integer(40));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, new Integer(192));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC, new Integer(128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, new Integer(128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, new Integer(40));
        noIvAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4);
        noIvAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4);
        desAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
        desAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
    }
}

