/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.pig;

import com.geoxp.oss.CryptoHelper;
import com.geoxp.oss.OSSException;
import com.geoxp.oss.client.OSSClient;
import com.geoxp.oss.jarjar.org.apache.zookeeper.CreateMode;
import com.geoxp.oss.jarjar.org.apache.zookeeper.KeeperException;
import com.geoxp.oss.jarjar.org.apache.zookeeper.ZooDefs;
import com.geoxp.oss.jarjar.org.apache.zookeeper.ZooKeeper;
import com.geoxp.oss.jarjar.org.apache.zookeeper.data.ACL;
import com.geoxp.oss.jarjar.org.bouncycastle.util.encoders.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;

public class PigSecretStore
extends EvalFunc<Object> {
    private static String PSS_FILE = "pss.file";
    public static final String PSS_OSS_URL = "pss.oss.url";
    public static final String PSS_OSS_SSHKEY = "pss.oss.sshkey";
    public static final String PSS_ZK_QUORUM = "pss.zk.quorum";
    public static final String PSS_ZK_ROOT = "pss.zk.root";
    private static final Map<String, byte[]> secrets = new HashMap<String, byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PigSecretStore(String ... args) {
        Map<String, byte[]> map = secrets;
        synchronized (map) {
            if (secrets.isEmpty()) {
                Properties props = UDFContext.getUDFContext().getUDFProperties(PigSecretStore.class);
                if (props.containsKey(PSS_FILE)) {
                    try {
                        String line;
                        String line2;
                        InputStream pssis = PigSecretStore.class.getClassLoader().getResourceAsStream(props.getProperty(PSS_FILE));
                        BufferedReader br = new BufferedReader(new InputStreamReader(pssis));
                        String zknode = br.readLine();
                        while (null != (line2 = br.readLine())) {
                            String[] tokens = line2.split(" ");
                            if (2 != tokens.length) {
                                throw new RuntimeException("Invalid PSS_FILE content.");
                            }
                            secrets.put(tokens[0], Base64.decode(tokens[1].getBytes("UTF-8")));
                        }
                        br.close();
                        ZooKeeper zk = new ZooKeeper(UDFContext.getUDFContext().getClientSystemProps().getProperty(PSS_ZK_QUORUM), 5000, null);
                        String zkdata = new String(zk.getData(zknode, false, null), "UTF-8");
                        zk.close();
                        br = new BufferedReader(new StringReader(zkdata));
                        while (null != (line = br.readLine())) {
                            String[] tokens = line.split(" ");
                            if (2 != tokens.length) {
                                throw new RuntimeException("Invalid PSS_FILE content.");
                            }
                            byte[] otp = Base64.decode(tokens[1].getBytes("UTF-8"));
                            for (int i = 0; i < otp.length; ++i) {
                                PigSecretStore.secrets.get((Object)tokens[0])[i] = (byte)(secrets.get(tokens[0])[i] ^ otp[i]);
                            }
                        }
                        br.close();
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    catch (KeeperException ke) {
                        throw new RuntimeException(ke);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                props.setProperty(PSS_FILE, args[0]);
                List<String> secrets = Arrays.asList(args).subList(1, args.length);
                try {
                    StringBuilder sb = new StringBuilder();
                    String uuid = UUID.randomUUID().toString();
                    String zknode = System.getProperty(PSS_ZK_ROOT) + "/" + uuid;
                    PrintWriter pw = new PrintWriter(args[0], "UTF-8");
                    pw.println(zknode);
                    for (String secretname : secrets) {
                        byte[] secret = OSSClient.getSecret(System.getProperty(PSS_OSS_URL), secretname, System.getProperty(PSS_OSS_SSHKEY));
                        byte[] otp = new byte[secret.length];
                        CryptoHelper.getSecureRandom().nextBytes(otp);
                        for (int i = 0; i < secret.length; ++i) {
                            secret[i] = (byte)(secret[i] ^ otp[i]);
                        }
                        pw.print(secretname);
                        pw.print(" ");
                        pw.println(new String(Base64.encode(secret), "UTF-8"));
                        sb.append(secretname);
                        sb.append(" ");
                        sb.append(new String(Base64.encode(otp), "UTF-8"));
                        sb.append("\n");
                    }
                    pw.close();
                    ZooKeeper zk = new ZooKeeper(System.getProperty(PSS_ZK_QUORUM), 5000, null);
                    ArrayList<ACL> acls = new ArrayList<ACL>();
                    acls.add(new ACL(31, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                    zk.create(zknode, sb.toString().getBytes("UTF-8"), acls, CreateMode.EPHEMERAL);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (KeeperException ke) {
                    throw new RuntimeException(ke);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                catch (OSSException osse) {
                    throw new RuntimeException(osse);
                }
            }
        }
    }

    public Object exec(Tuple input) throws IOException {
        if (1 == input.size()) {
            return input.get(0);
        }
        if (2 == input.size()) {
            return new DataByteArray(CryptoHelper.unwrapBlob(PigSecretStore.getSecret((String)input.get(0)), ((DataByteArray)input.get(1)).get()));
        }
        throw new IOException("Invalid input Tuple size, may be 1 or 2.");
    }

    public Schema outputSchema(Schema input) {
        return input;
    }

    public static byte[] getSecret(String name) {
        return (byte[])secrets.get(name).clone();
    }
}

