/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import com.google.common.io.Files;
import io.warp10.WarpURLDecoder;
import io.warp10.continuum.Tokens;
import io.warp10.continuum.store.Constants;
import io.warp10.script.WarpFleetMacroRepository;
import io.warp10.script.WarpScriptJarRepository;
import io.warp10.script.WarpScriptMacroRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WarpConfig {
    public static final String WARP10_CONFIG = "warp10.config";
    public static final String WARP10_CONFIG_ENV = "WARP10_CONFIG";
    public static final String WARPSCRIPT_BOOTSTRAP = "warpscript.bootstrap";
    private static Properties properties = null;

    public static void safeSetProperties(String file) throws IOException {
        if (null != properties) {
            return;
        }
        if (null == file) {
            WarpConfig.safeSetProperties((Reader)null);
        } else {
            WarpConfig.safeSetProperties(new FileReader(file));
        }
    }

    public static void setProperties(String[] files) throws IOException {
        if (null == files || 0 == files.length) {
            WarpConfig.setProperties((Reader)null);
        } else {
            ArrayList<String> filenames = new ArrayList<String>(Arrays.asList(files));
            StringBuilder sb = new StringBuilder();
            while (!filenames.isEmpty()) {
                String file = (String)filenames.remove(0);
                boolean atfile = '@' == file.charAt(0);
                List lines = Files.readLines((File)new File(atfile ? file.substring(1) : file), (Charset)StandardCharsets.UTF_8);
                if (atfile) {
                    filenames.addAll(0, lines);
                    continue;
                }
                for (String line : lines) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            WarpConfig.setProperties(new StringReader(sb.toString()));
        }
    }

    public static void setProperties(String file) throws IOException {
        if (null == file) {
            WarpConfig.setProperties((Reader)null);
        } else {
            WarpConfig.setProperties(new FileReader(file));
        }
    }

    public static void safeSetProperties(Reader reader) throws IOException {
        if (null != properties) {
            return;
        }
        WarpConfig.setProperties(reader);
    }

    public static boolean isPropertiesSet() {
        return null != properties;
    }

    public static void setProperties(Reader reader) throws IOException {
        if (null != properties) {
            throw new RuntimeException("Properties already set.");
        }
        properties = null != reader ? WarpConfig.readConfig(reader, null) : WarpConfig.readConfig(new StringReader(""), null);
        long warpTimeunits = Constants.TIME_UNITS_PER_MS;
        if (null != properties.getProperty("warp.token.file")) {
            Tokens.init(properties.getProperty("warp.token.file"));
        }
        WarpScriptMacroRepository.init(properties);
        WarpScriptJarRepository.init(properties);
        WarpFleetMacroRepository.init(properties);
    }

    private static Properties readConfig(InputStream file, Properties properties) throws IOException {
        return WarpConfig.readConfig(new InputStreamReader(file), properties);
    }

    public static Properties readConfig(Reader reader, Properties properties) throws IOException {
        return WarpConfig.readConfig(reader, properties, true);
    }

    public static Properties readConfig(Reader reader, Properties properties, boolean expandVars) throws IOException {
        Object line;
        if (null == properties) {
            properties = new Properties();
        }
        BufferedReader br = new BufferedReader(reader);
        int lineno = 0;
        int errorcount = 0;
        while (null != (line = br.readLine())) {
            line = ((String)line).trim();
            ++lineno;
            if ("".equals(line) || ((String)line).startsWith("//") || ((String)line).startsWith("#") || ((String)line).startsWith("--")) continue;
            if (!((String)line).contains("=")) {
                System.err.println("Line " + lineno + " is missing an '=' sign, skipping.");
                continue;
            }
            String[] stringArray = ((String)line).split("=");
            if (stringArray.length > 2) {
                System.err.println("Invalid syntax on line " + lineno + ", will force an abort.");
                ++errorcount;
                continue;
            }
            if (stringArray.length < 2) {
                System.err.println("Empty value for property '" + stringArray[0] + "', ignoring.");
                continue;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = WarpURLDecoder.decode(stringArray[i], StandardCharsets.UTF_8);
                stringArray[i] = stringArray[i].trim();
            }
            if ("".equals(stringArray[1])) continue;
            properties.setProperty(stringArray[0], stringArray[1]);
        }
        br.close();
        if (errorcount > 0) {
            System.err.println("Aborting due to " + errorcount + " error" + (errorcount > 1 ? "s" : "") + ".");
            System.exit(-1);
        }
        if (expandVars) {
            for (Map.Entry entry : System.getenv().entrySet()) {
                String string = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    String string2 = WarpURLDecoder.decode(string, StandardCharsets.UTF_8);
                    value = WarpURLDecoder.decode(value, StandardCharsets.UTF_8);
                    properties.setProperty(string2, value);
                }
                catch (Exception e) {
                    System.err.println("Warning: failed to decode environment variable '" + (String)entry.getKey() + "' = '" + (String)entry.getValue() + "', using raw value.");
                    properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            Properties sysprops = System.getProperties();
            for (Map.Entry<Object, Object> entry : sysprops.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                try {
                    name = WarpURLDecoder.decode(name, StandardCharsets.UTF_8);
                    value = WarpURLDecoder.decode(value, StandardCharsets.UTF_8);
                    properties.setProperty(name, value);
                }
                catch (Exception e) {
                    System.err.println("Error decoding system property '" + entry.getKey().toString() + "' = '" + entry.getValue().toString() + "', using raw values.");
                    properties.setProperty(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            Pattern pattern = Pattern.compile(".*\\$\\{([^}]+)\\}.*");
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Matcher m;
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                if ("''".equals(value)) {
                    value = "";
                }
                int loopcount = 0;
                while ((m = pattern.matcher(value)).matches()) {
                    String var = m.group(1);
                    if (properties.containsKey(var)) {
                        value = value.replace("${" + var + "}", properties.getProperty(var));
                    } else {
                        System.err.println("Property '" + var + "' referenced in property '" + name + "' is unset, unsetting '" + name + "'");
                        value = null;
                    }
                    if (null == value) break;
                    if (++loopcount <= 100) continue;
                    System.err.println("Hmmm, that's embarrassing, but I've been dereferencing variables " + loopcount + " times trying to set a value for '" + name + "'.");
                    System.exit(-1);
                }
                if (null == value) {
                    hashSet.add(name);
                    continue;
                }
                properties.setProperty(name, value);
            }
            for (String property : hashSet) {
                properties.remove(property);
            }
        }
        return properties;
    }

    public static Properties getProperties() {
        if (null == properties) {
            return null;
        }
        return (Properties)properties.clone();
    }

    public static String getProperty(String key) {
        if (null == properties) {
            throw new RuntimeException("Properties not set.");
        }
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (null == properties) {
            throw new RuntimeException("Properties not set.");
        }
        return properties.getProperty(key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object setProperty(String key, String value) {
        if (null == properties) {
            return null;
        }
        Properties properties = WarpConfig.properties;
        synchronized (properties) {
            if (null == value) {
                return WarpConfig.properties.remove(key);
            }
            return WarpConfig.properties.setProperty(key, value);
        }
    }

    public static void main(String ... args) {
        if (2 > args.length) {
            System.err.println("2 arguments minimum required: properties files and the property key");
            System.exit(-1);
        }
        if (null != properties) {
            System.err.println("Properties already set");
            System.exit(-1);
        }
        String[] files = Arrays.copyOf(args, args.length - 1);
        String key = args[args.length - 1];
        try {
            WarpConfig.setProperties(files);
            properties = WarpConfig.getProperties();
            System.out.println(key + "=" + WarpConfig.getProperty(key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

