/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Dedupper {
    private LinkedHashMap<String, Long> lastTimestamp = new LinkedHashMap();
    private LinkedHashMap<String, String> lastLocationElevationValue = new LinkedHashMap();
    private LinkedHashMap<String, String> lastDiscardedLine = new LinkedHashMap();
    private Pattern REGEXP = Pattern.compile("^([0-9]+)/([^/]*)/([0-9]*)\\s+([^\\s]+)\\s+(.*)$");
    private final long heartbeat;
    private final OutputStream os;

    public Dedupper(OutputStream os, long heartbeat) {
        this.heartbeat = heartbeat;
        this.os = os;
    }

    public void dedup(String line) throws IOException {
        Matcher m = this.REGEXP.matcher(line);
        if (!m.matches()) {
            throw new IOException("Invalid syntax.");
        }
        long timestamp = Long.valueOf(m.group(1));
        String location = m.group(2);
        String elevation = m.group(3);
        String class_labels = m.group(4);
        String value = m.group(5);
        Long lastts = this.lastTimestamp.get(class_labels);
        StringBuilder sb = new StringBuilder();
        sb.append(location);
        sb.append("/");
        sb.append(elevation);
        sb.append(value);
        String locelevvalue = sb.toString();
        if (null == lastts || timestamp - lastts > this.heartbeat || !locelevvalue.equals(this.lastLocationElevationValue.get(class_labels))) {
            this.os.write(line.getBytes(StandardCharsets.UTF_8));
            this.os.write(10);
            this.lastTimestamp.put(class_labels, timestamp);
            this.lastLocationElevationValue.put(class_labels, locelevvalue);
            this.lastDiscardedLine.remove(class_labels);
            return;
        }
        this.lastDiscardedLine.put(class_labels, line);
    }

    public void flush() throws IOException {
        for (String line : this.lastDiscardedLine.values()) {
            this.os.write(line.getBytes(StandardCharsets.UTF_8));
            this.os.write(10);
        }
    }

    public void reset() {
        this.lastTimestamp.clear();
        this.lastLocationElevationValue.clear();
        this.lastDiscardedLine.clear();
    }

    public void close() {
        this.reset();
    }
}

