/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;

public class GTSOpsHelper {
    public static void handleBucketization(GeoTimeSerie result, GeoTimeSerie gts1, GeoTimeSerie gts2) {
        if (GTSHelper.isBucketized(gts1) && GTSHelper.isBucketized(gts2) && GTSHelper.getBucketSpan(gts1) == GTSHelper.getBucketSpan(gts2)) {
            long bucketspan = GTSHelper.getBucketSpan(gts1);
            if (GTSHelper.getLastBucket(gts1) % bucketspan == GTSHelper.getLastBucket(gts2) % bucketspan) {
                GTSHelper.setBucketSpan(result, bucketspan);
                GTSHelper.setLastBucket(result, Math.max(GTSHelper.getLastBucket(gts1), GTSHelper.getLastBucket(gts2)));
                long firstbucket = Math.min(GTSHelper.getLastBucket(gts1) - (long)(GTSHelper.getBucketCount(gts1) - 1) * bucketspan, GTSHelper.getLastBucket(gts2) - (long)(GTSHelper.getBucketCount(gts2) - 1) * bucketspan);
                int bucketcount = (int)((GTSHelper.getLastBucket(result) - firstbucket) / bucketspan) + 1;
                GTSHelper.setBucketCount(result, bucketcount);
            }
        }
    }

    public static void applyBinaryOp(GeoTimeSerie result, GeoTimeSerie gts1, GeoTimeSerie gts2, GTSBinaryOp op) {
        GTSOpsHelper.applyBinaryOp(result, gts1, gts2, op, false);
    }

    public static void applyBinaryOp(GeoTimeSerie result, GeoTimeSerie gts1, GeoTimeSerie gts2, GTSBinaryOp op, boolean copyGts1Location) {
        GTSOpsHelper.handleBucketization(result, gts1, gts2);
        GTSHelper.sort(gts1);
        GTSHelper.sort(gts2);
        int idxa = 0;
        int idxb = 0;
        int na = GTSHelper.nvalues(gts1);
        int nb = GTSHelper.nvalues(gts2);
        Long tsa = null;
        Long tsb = null;
        if (idxa < na) {
            tsa = GTSHelper.tickAtIndex(gts1, idxa);
        }
        if (idxb < na) {
            tsb = GTSHelper.tickAtIndex(gts2, idxb);
        }
        while (idxa < na || idxb < nb) {
            if (idxa >= na) {
                tsa = null;
            }
            if (idxb >= nb) {
                tsb = null;
            }
            if (null != tsa && null != tsb) {
                if (0 == tsa.compareTo(tsb)) {
                    if (copyGts1Location) {
                        GTSHelper.setValue(result, tsa, GTSHelper.locationAtIndex(gts1, idxa), GTSHelper.elevationAtIndex(gts1, idxa), op.op(gts1, gts2, idxa, idxb), false);
                    } else {
                        GTSHelper.setValue(result, tsa, op.op(gts1, gts2, idxa, idxb));
                    }
                    ++idxa;
                    ++idxb;
                } else if (tsa < tsb) {
                    ++idxa;
                } else {
                    ++idxb;
                }
            } else if (null == tsa && null != tsb) {
                ++idxb;
            } else if (null == tsb && null != tsa) {
                ++idxa;
            }
            if (idxa < na) {
                tsa = GTSHelper.tickAtIndex(gts1, idxa);
            }
            if (idxb >= nb) continue;
            tsb = GTSHelper.tickAtIndex(gts2, idxb);
        }
    }

    public static interface GTSBinaryOp {
        public Object op(GeoTimeSerie var1, GeoTimeSerie var2, int var3, int var4);
    }
}

