/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class IFFT {
    public static GeoTimeSerie ifft(GeoTimeSerie re, GeoTimeSerie im) throws WarpScriptException {
        GTSHelper.sort(re);
        GTSHelper.sort(im);
        if (GTSHelper.nvalues(re) != GTSHelper.nvalues(im)) {
            throw new WarpScriptException("Real and imaginary Geo Time Series MUST have the same number of values.");
        }
        int n = GTSHelper.nvalues(re);
        double[] x = new double[n + n];
        for (int i = 0; i < n; ++i) {
            x[2 * i] = ((Number)GTSHelper.valueAtIndex(re, i)).doubleValue();
            x[2 * i + 1] = ((Number)GTSHelper.valueAtIndex(im, i)).doubleValue();
        }
        DoubleFFT_1D dfft = new DoubleFFT_1D(n);
        dfft.complexInverse(x, true);
        GeoTimeSerie gts = new GeoTimeSerie(n);
        gts.setName(re.getMetadata().getName());
        gts.setLabels(re.getLabels());
        for (int i = 0; i < n; ++i) {
            GTSHelper.setValue(gts, i, x[2 * i]);
        }
        return gts;
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object im = stack.pop();
            if (!(im instanceof GeoTimeSerie)) {
                throw new WarpScriptException(this.getName() + " expects a Geo Time Series of imaginary parts on top of the stack.");
            }
            Object re = stack.pop();
            if (!(re instanceof GeoTimeSerie)) {
                throw new WarpScriptException(this.getName() + " expects a Geo Time Series of real parts below the imaginary parts GTS.");
            }
            if (GeoTimeSerie.TYPE.DOUBLE != ((GeoTimeSerie)re).getType() || GeoTimeSerie.TYPE.DOUBLE != ((GeoTimeSerie)im).getType()) {
                throw new WarpScriptException(this.getName() + " real and imaginary parts GTS MUST be of type DOUBLE.");
            }
            stack.push(IFFT.ifft((GeoTimeSerie)re, (GeoTimeSerie)im));
            return stack;
        }
    }
}

