/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public abstract class ValueEncoder {
    private static final List<ValueEncoder> encoders = new ArrayList<ValueEncoder>();

    public static void register(ValueEncoder encoder) {
        encoders.add(encoder);
    }

    public abstract Object parseValue(String var1) throws Exception;

    public static Object parse(String value) throws Exception {
        for (ValueEncoder encoder : encoders) {
            Object o = encoder.parseValue(value);
            if (null == o) continue;
            if (o instanceof Long || o instanceof Double || o instanceof String || o instanceof Boolean || o instanceof BigDecimal || o instanceof byte[]) {
                return o;
            }
            throw new ParseException("Unsupported value type " + o.getClass() + " for value '" + value + "'", 0);
        }
        throw new ParseException("Unsupported value '" + value + "'", 0);
    }
}

