/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.crypto;

import io.warp10.crypto.KeyStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class UnsecureKeyStore
implements KeyStore {
    private final Map<String, byte[]> keys = new HashMap<String, byte[]>();

    @Override
    public byte[] getKey(String name) {
        return this.keys.get(name);
    }

    @Override
    public void setKey(String name, byte[] bits) {
        this.keys.put(name, bits);
    }

    @Override
    public byte[] decodeKey(String encoded) {
        if (null == encoded) {
            return null;
        }
        if (encoded.startsWith("hex:")) {
            return Hex.decode((String)encoded.substring(4));
        }
        if (encoded.startsWith("base64:")) {
            return Base64.decode((String)encoded.substring(7));
        }
        return null;
    }

    @Override
    public KeyStore clone() {
        UnsecureKeyStore uks = new UnsecureKeyStore();
        for (Map.Entry<String, byte[]> entry : this.keys.entrySet()) {
            uks.setKey(entry.getKey().intern(), Arrays.copyOf(entry.getValue(), entry.getValue().length));
        }
        return uks;
    }

    @Override
    public void forget() {
    }
}

