/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.json;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import io.warp10.json.BoundedWriter;
import io.warp10.json.BytesSerializer;
import io.warp10.json.GTSEncoderSerializer;
import io.warp10.json.GeoTimeSerieSerializer;
import io.warp10.json.MacroSerializer;
import io.warp10.json.MetadataSerializer;
import io.warp10.json.NamedWarpScriptFunctionSerializer;
import io.warp10.json.RealMatrixSerializer;
import io.warp10.json.RealVectorSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonUtils {
    public static final NullKeySerializer nullKeySerializer = new NullKeySerializer();
    public static final CustomEncodersSerializer customEncodersSerializer = new CustomEncodersSerializer();
    private static final ObjectMapper strictMapper;
    private static final ObjectMapper looseMapper;
    private static List<JsonEncoder> encoders;

    public static Object jsonToObject(String json) throws JsonProcessingException {
        return strictMapper.readValue(json, Object.class);
    }

    public static String objectToJson(Object o) throws IOException {
        return JsonUtils.objectToJson(o, Long.MAX_VALUE);
    }

    public static String objectToJson(Object o, long maxJsonSize) throws IOException {
        return JsonUtils.objectToJson(o, false, maxJsonSize);
    }

    public static String objectToJson(Object o, boolean isStrict) throws IOException {
        return JsonUtils.objectToJson(o, isStrict, Long.MAX_VALUE);
    }

    public static String objectToJson(Object o, boolean isStrict, long maxJsonSize) throws IOException {
        StringWriter writer = new StringWriter();
        JsonUtils.objectToJson(writer, o, isStrict, maxJsonSize);
        return writer.toString();
    }

    public static void objectToJson(Writer writer, Object o, boolean isStrict) throws IOException {
        JsonUtils.objectToJson(writer, o, isStrict, Long.MAX_VALUE);
    }

    public static void objectToJson(Writer writer, Object o, boolean isStrict, long maxJsonSize) throws IOException {
        if (Long.MAX_VALUE != maxJsonSize) {
            writer = new BoundedWriter(writer, maxJsonSize);
        }
        try {
            if (isStrict) {
                strictMapper.writeValue(writer, o);
            } else {
                looseMapper.writeValue(writer, o);
            }
        }
        catch (BoundedWriter.WriterBoundReachedException wbre) {
            throw new IOException("Resulting JSON is too big.", wbre);
        }
    }

    public static synchronized void addEncoder(JsonEncoder encoder) {
        if (null == encoders) {
            encoders = new ArrayList<JsonEncoder>();
        }
        encoders.add(encoder);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier((BeanSerializerModifier)new NotSerializedToCustomSerializedModifier());
        module.addSerializer((JsonSerializer)new GeoTimeSerieSerializer());
        module.addSerializer((JsonSerializer)new GTSEncoderSerializer());
        module.addSerializer((JsonSerializer)new MetadataSerializer());
        module.addSerializer((JsonSerializer)new NamedWarpScriptFunctionSerializer());
        module.addSerializer((JsonSerializer)new MacroSerializer());
        module.addSerializer((JsonSerializer)new BytesSerializer());
        module.addSerializer((JsonSerializer)new RealVectorSerializer());
        module.addSerializer((JsonSerializer)new RealMatrixSerializer());
        JsonFactoryBuilder builder = new JsonFactoryBuilder();
        builder.enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS);
        builder.enable(JsonReadFeature.ALLOW_MISSING_VALUES);
        builder.enable(JsonWriteFeature.ESCAPE_NON_ASCII);
        builder.disable(JsonWriteFeature.WRITE_NUMBERS_AS_STRINGS);
        builder.disable(StreamWriteFeature.AUTO_CLOSE_TARGET);
        builder.enable(JsonWriteFeature.WRITE_NAN_AS_STRINGS);
        strictMapper = new ObjectMapper(builder.build());
        strictMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)nullKeySerializer);
        strictMapper.registerModule((Module)module);
        builder.disable(JsonWriteFeature.WRITE_NAN_AS_STRINGS);
        looseMapper = new ObjectMapper(builder.build());
        looseMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)nullKeySerializer);
        looseMapper.registerModule((Module)module);
    }

    public static interface JsonEncoder {
        public boolean addElement(StringBuilder var1, Object var2);
    }

    public static class CustomEncodersSerializer
    extends JsonSerializer<Object> {
        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (null != encoders && !encoders.isEmpty()) {
                JsonEncoder encoder;
                StringBuilder sb = new StringBuilder();
                boolean encoded = false;
                Iterator iterator = encoders.iterator();
                while (iterator.hasNext() && !(encoded = (encoder = (JsonEncoder)iterator.next()).addElement(sb, value))) {
                }
                if (encoded) {
                    gen.writeRaw(sb.toString());
                } else {
                    gen.writeNull();
                }
            } else {
                gen.writeNull();
            }
        }
    }

    public static class NotSerializedToCustomSerializedModifier
    extends BeanSerializerModifier {
        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (serializer instanceof UnknownSerializer || serializer instanceof BeanSerializer) {
                return customEncodersSerializer;
            }
            return serializer;
        }
    }

    private static class NullKeySerializer
    extends JsonSerializer<Object> {
        private NullKeySerializer() {
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName("null");
        }
    }
}

