/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import com.geoxp.GeoXPLib;
import io.warp10.FloatUtils;
import io.warp10.WarpURLEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.UnsafeString;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.json.JsonUtils;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.SNAPSHOT;
import io.warp10.warp.sdk.WarpScriptJavaFunctionGTS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StackUtils {
    public static void toJSON(PrintWriter out, WarpScriptStack stack, int maxdepth, long maxJsonSize) throws WarpScriptException, IOException {
        boolean strictJSON = Boolean.TRUE.equals(stack.getAttribute("json.strict"));
        int depth = Math.min(stack.depth(), maxdepth);
        out.print("[");
        boolean first = true;
        for (int i = 0; i < depth; ++i) {
            if (!first) {
                out.print(",");
            }
            first = false;
            Object o = stack.get(i);
            JsonUtils.objectToJson(out, o, strictJSON, maxJsonSize);
        }
        out.print("]");
    }

    public static void toJSON(PrintWriter out, WarpScriptStack stack) throws WarpScriptException, IOException {
        StackUtils.toJSON(out, stack, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    public static StringBuilder sanitize(String script) throws WarpScriptException {
        StringBuilder sb = new StringBuilder();
        if (null == script) {
            return sb;
        }
        BufferedReader br = new BufferedReader(new StringReader(script));
        boolean inComment = false;
        try {
            String line;
            block2: while (null != (line = br.readLine())) {
                line = line.trim();
                String[] statements = -1 != UnsafeString.indexOf(line = UnsafeString.sanitizeStrings(line), ' ') ? UnsafeString.split(line, ' ') : new String[]{line};
                for (String stmt : statements) {
                    if (0 == stmt.length()) continue;
                    if ((stmt = stmt.trim()).charAt(0) == '#' || stmt.charAt(0) == '/' && stmt.length() >= 2 && stmt.charAt(1) == '/') continue block2;
                    if ("*/".equals(stmt)) {
                        if (inComment) {
                            throw new WarpScriptException("Not inside a comment.");
                        }
                        inComment = false;
                        continue;
                    }
                    if (inComment) continue;
                    if ("/*".equals(stmt)) {
                        inComment = true;
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(stmt);
                }
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        return sb;
    }

    public static Object toSDKObject(Object o) throws WarpScriptException {
        if (o instanceof String || o instanceof Long || o instanceof Double || o instanceof Boolean) {
            return o;
        }
        if (o instanceof GeoTimeSerie) {
            GeoTimeSerie inGTS = (GeoTimeSerie)o;
            WarpScriptJavaFunctionGTS gts = new WarpScriptJavaFunctionGTS();
            Metadata metadata = inGTS.getMetadata();
            gts.gtsClass = inGTS.getName();
            gts.gtsLabels = Collections.unmodifiableMap(metadata.getLabels());
            gts.gtsAttributes = Collections.unmodifiableMap(metadata.getAttributes());
            if (GTSHelper.isBucketized(inGTS)) {
                gts.bucketized = true;
                gts.bucketcount = GTSHelper.getBucketCount(inGTS);
                gts.bucketspan = GTSHelper.getBucketSpan(inGTS);
                gts.lastbucket = GTSHelper.getLastBucket(inGTS);
            } else {
                gts.bucketized = false;
            }
            if (0 == GTSHelper.nvalues(inGTS)) {
                return gts;
            }
            gts.ticks = GTSHelper.getTicks(inGTS);
            if (inGTS.hasLocations()) {
                long[] locations = GTSHelper.getOriginalLocations(inGTS);
                gts.latitudes = new float[locations.length];
                gts.longitudes = new float[locations.length];
                for (int i = 0; i < locations.length; ++i) {
                    if (91480763316633925L != locations[i]) {
                        double[] latlon = GeoXPLib.fromGeoXPPoint((long)locations[i]);
                        gts.latitudes[i] = (float)latlon[0];
                        gts.longitudes[i] = (float)latlon[1];
                        continue;
                    }
                    gts.latitudes[i] = Float.NaN;
                    gts.longitudes[i] = Float.NaN;
                }
            } else {
                gts.latitudes = null;
                gts.longitudes = null;
            }
            gts.elevations = (long[])(inGTS.hasElevations() ? GTSHelper.getElevations(inGTS) : null);
            switch (inGTS.getType()) {
                case BOOLEAN: {
                    gts.booleanValues = GTSHelper.booleanValues(inGTS);
                    break;
                }
                case DOUBLE: {
                    gts.doubleValues = GTSHelper.doubleValues(inGTS);
                    break;
                }
                case LONG: {
                    gts.longValues = GTSHelper.longValues(inGTS);
                    break;
                }
                case STRING: {
                    gts.stringValues = GTSHelper.stringValues(inGTS);
                    break;
                }
            }
            return gts;
        }
        if (o instanceof List) {
            ArrayList<Object> newlist = new ArrayList<Object>(((List)o).size());
            for (Object in : (List)o) {
                if (!(in instanceof List) && !(in instanceof Map)) {
                    Object out = StackUtils.toSDKObject(in);
                    newlist.add(out);
                    continue;
                }
                throw new WarpScriptException("Invalid nested complex type.");
            }
            return newlist;
        }
        if (o instanceof Map) {
            HashMap<Object, Object> newmap = new HashMap<Object, Object>(((Map)o).size());
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof List || key instanceof Map || value instanceof List || value instanceof Map)) {
                    newmap.put(StackUtils.toSDKObject(key), StackUtils.toSDKObject(value));
                    continue;
                }
                throw new WarpScriptException("Invalid nested complex type.");
            }
            return newmap;
        }
        throw new WarpScriptException("Unsupported type " + o.getClass());
    }

    public static Object fromSDKObject(Object o) throws WarpScriptException {
        if (o instanceof String || o instanceof Long || o instanceof Double || o instanceof Boolean) {
            return o;
        }
        if (o instanceof Integer || o instanceof Short || o instanceof Byte || o instanceof BigInteger) {
            return ((Number)o).longValue();
        }
        if (o instanceof Float || o instanceof BigDecimal) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof WarpScriptJavaFunctionGTS) {
            WarpScriptJavaFunctionGTS inGTS = (WarpScriptJavaFunctionGTS)o;
            int len = null != inGTS.ticks ? inGTS.ticks.length : 0;
            GeoTimeSerie gts = inGTS.bucketized ? new GeoTimeSerie(inGTS.lastbucket, inGTS.bucketcount, inGTS.bucketspan, len) : new GeoTimeSerie(len);
            Metadata metadata = new Metadata();
            if (null != inGTS.gtsClass) {
                metadata.setName(inGTS.gtsClass);
            }
            if (null != inGTS.gtsLabels) {
                metadata.setLabels(new HashMap<String, String>(inGTS.gtsLabels));
            } else {
                metadata.setLabels(new HashMap<String, String>());
            }
            if (null != inGTS.gtsAttributes) {
                metadata.setAttributes(new HashMap<String, String>(inGTS.gtsAttributes));
            } else {
                metadata.setAttributes(new HashMap<String, String>());
            }
            if (0 == len) {
                return gts;
            }
            boolean hasLocations = false;
            if (null != inGTS.latitudes && null != inGTS.longitudes) {
                if (inGTS.latitudes.length != len || inGTS.longitudes.length != len) {
                    throw new WarpScriptException("Incoherent number of latitudes (" + inGTS.latitudes.length + ") / longitudes (" + inGTS.longitudes.length + "), expected " + len);
                }
                hasLocations = true;
            } else {
                if (null != inGTS.latitudes) {
                    throw new WarpScriptException("Missing longitudes.");
                }
                if (null != inGTS.longitudes) {
                    throw new WarpScriptException("Missing latitudes.");
                }
            }
            boolean hasElevations = false;
            if (null != inGTS.elevations && inGTS.elevations.length != len) {
                throw new WarpScriptException("Incoherent number of elevations (" + inGTS.elevations.length + "), expected " + len);
            }
            GeoTimeSerie.TYPE type = GeoTimeSerie.TYPE.UNDEFINED;
            if (null != inGTS.booleanValues) {
                type = GeoTimeSerie.TYPE.BOOLEAN;
                if (inGTS.booleanValues.size() < len) {
                    throw new WarpScriptException("Incoherent size for boolean values (" + inGTS.booleanValues.size() + "), or less expected " + len);
                }
            }
            if (null != inGTS.longValues) {
                if (GeoTimeSerie.TYPE.UNDEFINED != type) {
                    throw new WarpScriptException("Incoherent GTS, multiple value types.");
                }
                type = GeoTimeSerie.TYPE.LONG;
                if (inGTS.longValues.length != len) {
                    throw new WarpScriptException("Incoherent size for long values (" + inGTS.longValues.length + "), expected " + len);
                }
            }
            if (null != inGTS.doubleValues) {
                if (GeoTimeSerie.TYPE.UNDEFINED != type) {
                    throw new WarpScriptException("Incoherent GTS, multiple value types.");
                }
                type = GeoTimeSerie.TYPE.DOUBLE;
                if (inGTS.doubleValues.length != len) {
                    throw new WarpScriptException("Incoherent size for double values (" + inGTS.doubleValues.length + "), expected " + len);
                }
            }
            if (null != inGTS.stringValues) {
                if (GeoTimeSerie.TYPE.UNDEFINED != type) {
                    throw new WarpScriptException("Incoherent GTS, multiple value types.");
                }
                type = GeoTimeSerie.TYPE.STRING;
                if (inGTS.stringValues.length != len) {
                    throw new WarpScriptException("Incoherent size for string values (" + inGTS.stringValues.length + "), expected " + len);
                }
            }
            for (int i = 0; i < inGTS.ticks.length; ++i) {
                long location = 91480763316633925L;
                long elevation = Long.MIN_VALUE;
                if (hasLocations && FloatUtils.isFinite(inGTS.latitudes[i]) && FloatUtils.isFinite(inGTS.longitudes[i])) {
                    location = GeoXPLib.toGeoXPPoint((double)inGTS.latitudes[i], (double)inGTS.longitudes[i]);
                }
                if (hasElevations && Long.MIN_VALUE != inGTS.elevations[i]) {
                    elevation = inGTS.elevations[i];
                }
                Object value = null;
                switch (type) {
                    case BOOLEAN: {
                        value = inGTS.booleanValues.get(i);
                        break;
                    }
                    case DOUBLE: {
                        value = inGTS.doubleValues[i];
                        break;
                    }
                    case LONG: {
                        value = inGTS.longValues[i];
                        break;
                    }
                    case STRING: {
                        value = inGTS.stringValues[i];
                        break;
                    }
                    default: {
                        throw new WarpScriptException("Invalid return type.");
                    }
                }
                GTSHelper.setValue(gts, inGTS.ticks[i], location, elevation, value, false);
            }
            return gts;
        }
        if (o instanceof List) {
            ArrayList<Object> newlist = new ArrayList<Object>(((List)o).size());
            for (Object in : (List)o) {
                if (!(in instanceof List) && !(in instanceof Map)) {
                    Object out = StackUtils.fromSDKObject(in);
                    newlist.add(out);
                    continue;
                }
                throw new WarpScriptException("Invalid nested complex type.");
            }
            return newlist;
        }
        if (o instanceof Map) {
            HashMap<Object, Object> newmap = new HashMap<Object, Object>(((Map)o).size());
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof List || key instanceof Map || value instanceof List || value instanceof Map)) {
                    newmap.put(StackUtils.fromSDKObject(key), StackUtils.fromSDKObject(value));
                    continue;
                }
                throw new WarpScriptException("Invalid nested complex type.");
            }
            return newmap;
        }
        return o.toString();
    }

    public static String toString(Object o) {
        StringBuilder sb = new StringBuilder();
        if (null == o) {
            sb.append("NULL");
        } else if (o instanceof Number) {
            sb.append(o);
        } else if (o instanceof String) {
            sb.append("'");
            try {
                sb.append(WarpURLEncoder.encode(o.toString(), StandardCharsets.UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            sb.append("'");
        } else if (o instanceof Boolean) {
            sb.append(Boolean.toString((Boolean)o));
        } else if (o instanceof WarpScriptStackFunction) {
            sb.append(o.toString());
        } else if (o instanceof SNAPSHOT.Snapshotable) {
            ((SNAPSHOT.Snapshotable)o).snapshot();
        } else if (o instanceof WarpScriptStack.Macro) {
            sb.append(o.toString());
        } else if (o instanceof NamedWarpScriptFunction) {
            sb.append(o.toString());
        }
        return sb.toString();
    }
}

