/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;

public class ShannonEntropy
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private final boolean invert;

    public ShannonEntropy(String name, boolean invert) {
        super(name);
        this.invert = invert;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        double sum = 0.0;
        int n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (null == values[i]) continue;
            if (!(values[i] instanceof Long)) {
                throw new WarpScriptException(this.getName() + " can only operate on long values.");
            }
            ++n;
            sum += (double)((Long)values[i]).longValue();
        }
        double H = 0.0;
        if (1 != n) {
            for (int i = 0; i < values.length; ++i) {
                long xi;
                if (null == values[i] || 0L == (xi = ((Long)values[i]).longValue())) continue;
                double pi = (double)xi / sum;
                double logpi = Math.log(pi);
                H -= pi * logpi;
            }
            H /= Math.log(n);
        } else if (this.invert) {
            H = 1.0;
        }
        return new Object[]{tick, 91480763316633925L, Long.MIN_VALUE, H};
    }
}

