/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class Variance
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptReducerFunction,
WarpScriptBucketizerFunction {
    private final boolean useBessel;
    private final boolean forbidNulls;

    public Variance(String name, boolean useBessel, boolean forbidNulls) {
        super(name);
        this.useBessel = useBessel;
        this.forbidNulls = forbidNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        double sum = 0.0;
        double sumsq = 0.0;
        GeoTimeSerie.TYPE type = null;
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        long timestamp = Long.MIN_VALUE;
        int nticks = 0;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (null == value && this.forbidNulls) {
                return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
            }
            if (null == value) continue;
            ++nticks;
            if (ticks[i] > timestamp) {
                location = locations[i];
                elevation = elevations[i];
                timestamp = ticks[i];
            }
            if (null == type) {
                if (value instanceof Long) {
                    type = GeoTimeSerie.TYPE.LONG;
                    sum = ((Number)value).doubleValue();
                    sumsq = sum * sum;
                    continue;
                }
                if (value instanceof Double) {
                    type = GeoTimeSerie.TYPE.DOUBLE;
                    sum = ((Number)value).doubleValue();
                    sumsq = sum * sum;
                    continue;
                }
                return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
            }
            double v = ((Number)value).doubleValue();
            sum += v;
            sumsq += v * v;
        }
        int n = nticks;
        double variance = sumsq / (double)n - sum * sum / ((double)n * (double)n);
        if (n > 1 && this.useBessel) {
            variance = variance * (double)n / ((double)n - 1.0);
        }
        return new Object[]{0L, location, elevation, variance};
    }

    @Override
    public String toString() {
        return Boolean.toString(this.forbidNulls) + " " + this.getName();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean forbidNulls;

        public Builder(String name, boolean forbidNulls) {
            super(name);
            this.forbidNulls = forbidNulls;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object o = stack.pop();
            if (!(o instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " expects a boolean parameter to determine whether or not to apply Bessel's correction.");
            }
            stack.push(new Variance(this.getName(), (Boolean)o, this.forbidNulls));
            return stack;
        }
    }
}

