/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.binary;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOpsHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.binary.EQ;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class ComparisonOperation
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean ifOneNaNOperand;
    private final boolean ifTwoNaNOperands;
    private final GTSOpsHelper.GTSBinaryOp stringOp = new GTSOpsHelper.GTSBinaryOp(){

        @Override
        public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
            return ComparisonOperation.this.operator(GTSHelper.valueAtIndex(gtsa, idxa).toString().compareTo(GTSHelper.valueAtIndex(gtsb, idxb).toString()), 0) ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
        }
    };
    private final GTSOpsHelper.GTSBinaryOp longOp = new GTSOpsHelper.GTSBinaryOp(){

        @Override
        public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
            return ComparisonOperation.this.operator(EQ.compare((Number)GTSHelper.valueAtIndex(gtsa, idxa), (Number)GTSHelper.valueAtIndex(gtsb, idxb)), 0) ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
        }
    };
    private final GTSOpsHelper.GTSBinaryOp doublesOp = new GTSOpsHelper.GTSBinaryOp(){

        @Override
        public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
            if (Double.isNaN((Double)GTSHelper.valueAtIndex(gtsa, idxa)) && Double.isNaN((Double)GTSHelper.valueAtIndex(gtsb, idxb))) {
                return ComparisonOperation.this.ifTwoNaNOperands ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
            }
            if (Double.isNaN((Double)GTSHelper.valueAtIndex(gtsa, idxa)) || Double.isNaN((Double)GTSHelper.valueAtIndex(gtsb, idxb))) {
                return ComparisonOperation.this.ifOneNaNOperand ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
            }
            return ComparisonOperation.this.operator(EQ.compare((Number)GTSHelper.valueAtIndex(gtsa, idxa), (Number)GTSHelper.valueAtIndex(gtsb, idxb)), 0) ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
        }
    };
    private final GTSOpsHelper.GTSBinaryOp gtsaIsDoubleOp = new GTSOpsHelper.GTSBinaryOp(){

        @Override
        public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
            if (Double.isNaN((Double)GTSHelper.valueAtIndex(gtsa, idxa))) {
                return ComparisonOperation.this.ifOneNaNOperand ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
            }
            return ComparisonOperation.this.operator(EQ.compare((Number)GTSHelper.valueAtIndex(gtsa, idxa), (Number)GTSHelper.valueAtIndex(gtsb, idxb)), 0) ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
        }
    };
    private final GTSOpsHelper.GTSBinaryOp gtsbIsDoubleOp = new GTSOpsHelper.GTSBinaryOp(){

        @Override
        public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
            if (Double.isNaN((Double)GTSHelper.valueAtIndex(gtsb, idxb))) {
                return ComparisonOperation.this.ifOneNaNOperand ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
            }
            return ComparisonOperation.this.operator(EQ.compare((Number)GTSHelper.valueAtIndex(gtsa, idxa), (Number)GTSHelper.valueAtIndex(gtsb, idxb)), 0) ? GTSHelper.valueAtIndex(gtsa, idxa) : null;
        }
    };

    public abstract boolean operator(int var1, int var2);

    public ComparisonOperation(String name) {
        super(name);
        this.ifOneNaNOperand = false;
        this.ifTwoNaNOperands = false;
    }

    public ComparisonOperation(String name, boolean trueIfOneNaNOperand, boolean trueIfTwoNaNOperands) {
        super(name);
        this.ifOneNaNOperand = trueIfOneNaNOperand;
        this.ifTwoNaNOperands = trueIfTwoNaNOperands;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object op2 = stack.pop();
        Object op1 = stack.pop();
        return this.comparison(stack, op1, op2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object comparison(WarpScriptStack stack, Object op1, Object op2) throws WarpScriptException {
        if (op1 instanceof Double && op2 instanceof Double && Double.isNaN((Double)op1) && Double.isNaN((Double)op2)) {
            stack.push(this.ifTwoNaNOperands);
            return stack;
        }
        if (op1 instanceof Double && Double.isNaN((Double)op1) && !(op2 instanceof GeoTimeSerie)) {
            stack.push(this.ifOneNaNOperand);
            return stack;
        }
        if (op2 instanceof Double && Double.isNaN((Double)op2) && !(op1 instanceof GeoTimeSerie)) {
            stack.push(this.ifOneNaNOperand);
            return stack;
        }
        if (op2 instanceof Number && op1 instanceof Number) {
            stack.push(this.operator(EQ.compare((Number)op1, (Number)op2), 0));
            return stack;
        }
        if (op2 instanceof String && op1 instanceof String) {
            stack.push(this.operator(op1.toString().compareTo(op2.toString()), 0));
            return stack;
        }
        if (op1 instanceof byte[] && op2 instanceof byte[]) {
            stack.push(this.operator(Bytes.compareTo((byte[])((byte[])op1), (byte[])((byte[])op2)), 0));
            return stack;
        }
        if (op1 instanceof GeoTimeSerie && op2 instanceof GeoTimeSerie) {
            GeoTimeSerie gts1 = (GeoTimeSerie)op1;
            GeoTimeSerie gts2 = (GeoTimeSerie)op2;
            if (GeoTimeSerie.TYPE.UNDEFINED == gts1.getType() || GeoTimeSerie.TYPE.UNDEFINED == gts2.getType()) {
                GeoTimeSerie result = new GeoTimeSerie();
                GTSOpsHelper.handleBucketization(result, gts1, gts2);
                stack.push(result);
                return stack;
            } else if (GeoTimeSerie.TYPE.STRING == gts1.getType() && GeoTimeSerie.TYPE.STRING == gts2.getType()) {
                GeoTimeSerie result = new GeoTimeSerie(Math.max(GTSHelper.nvalues(gts1), GTSHelper.nvalues(gts2)));
                result.setType(GeoTimeSerie.TYPE.STRING);
                GTSOpsHelper.applyBinaryOp(result, gts1, gts2, this.stringOp, true);
                if (0 == result.size()) {
                    result = result.cloneEmpty();
                }
                stack.push(result);
                return stack;
            } else {
                if (GeoTimeSerie.TYPE.LONG != gts1.getType() && GeoTimeSerie.TYPE.DOUBLE != gts1.getType() || GeoTimeSerie.TYPE.LONG != gts2.getType() && GeoTimeSerie.TYPE.DOUBLE != gts2.getType()) throw new WarpScriptException(this.getName() + "can only operate on two GTS with NUMBER or STRING values.");
                GeoTimeSerie result = new GeoTimeSerie(Math.max(GTSHelper.nvalues(gts1), GTSHelper.nvalues(gts2)));
                if (GeoTimeSerie.TYPE.DOUBLE == gts1.getType() && GeoTimeSerie.TYPE.DOUBLE == gts2.getType()) {
                    result.setType(GeoTimeSerie.TYPE.DOUBLE);
                    GTSOpsHelper.applyBinaryOp(result, gts1, gts2, this.doublesOp, true);
                } else if (GeoTimeSerie.TYPE.DOUBLE == gts1.getType() && GeoTimeSerie.TYPE.LONG == gts2.getType()) {
                    result.setType(GeoTimeSerie.TYPE.DOUBLE);
                    GTSOpsHelper.applyBinaryOp(result, gts1, gts2, this.gtsaIsDoubleOp, true);
                } else if (GeoTimeSerie.TYPE.LONG == gts1.getType() && GeoTimeSerie.TYPE.DOUBLE == gts2.getType()) {
                    result.setType(GeoTimeSerie.TYPE.DOUBLE);
                    GTSOpsHelper.applyBinaryOp(result, gts1, gts2, this.gtsbIsDoubleOp, true);
                } else {
                    result.setType(GeoTimeSerie.TYPE.LONG);
                    GTSOpsHelper.applyBinaryOp(result, gts1, gts2, this.longOp, true);
                }
                if (0 == result.size()) {
                    result = result.cloneEmpty();
                }
                stack.push(result);
            }
            return stack;
        }
        if (op1 instanceof GeoTimeSerie && GeoTimeSerie.TYPE.UNDEFINED == ((GeoTimeSerie)op1).getType() && (op2 instanceof String || op2 instanceof Number)) {
            stack.push(((GeoTimeSerie)op1).cloneEmpty());
            return stack;
        }
        if (op1 instanceof GeoTimeSerie && op2 instanceof String && GeoTimeSerie.TYPE.STRING == ((GeoTimeSerie)op1).getType()) {
            GeoTimeSerie gts = (GeoTimeSerie)op1;
            GeoTimeSerie result = gts.cloneEmpty();
            result.setType(GeoTimeSerie.TYPE.STRING);
            for (int i = 0; i < GTSHelper.nvalues(gts); ++i) {
                GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), this.operator(GTSHelper.valueAtIndex(gts, i).toString().compareTo(op2.toString()), 0) ? GTSHelper.valueAtIndex(gts, i) : null, false);
            }
            if (0 == result.size()) {
                result = result.cloneEmpty();
            }
            stack.push(result);
            return stack;
        }
        if (op1 instanceof GeoTimeSerie && op2 instanceof Number && GeoTimeSerie.TYPE.DOUBLE == ((GeoTimeSerie)op1).getType()) {
            GeoTimeSerie gts = (GeoTimeSerie)op1;
            GeoTimeSerie result = gts.cloneEmpty();
            result.setType(GeoTimeSerie.TYPE.DOUBLE);
            if (op2 instanceof Double && Double.isNaN((Double)op2)) {
                for (int i = 0; i < GTSHelper.nvalues(gts); ++i) {
                    if ((!Double.isNaN((Double)GTSHelper.valueAtIndex(gts, i)) || !this.ifTwoNaNOperands) && (Double.isNaN((Double)GTSHelper.valueAtIndex(gts, i)) || !this.ifOneNaNOperand)) continue;
                    GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
                }
            } else {
                for (int i = 0; i < GTSHelper.nvalues(gts); ++i) {
                    if (Double.isNaN((Double)GTSHelper.valueAtIndex(gts, i))) {
                        GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), this.ifOneNaNOperand ? GTSHelper.valueAtIndex(gts, i) : null, false);
                        continue;
                    }
                    GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), this.operator(EQ.compare((Number)GTSHelper.valueAtIndex(gts, i), (Number)op2), 0) ? GTSHelper.valueAtIndex(gts, i) : null, false);
                }
            }
            if (0 == result.size()) {
                result = result.cloneEmpty();
            }
            stack.push(result);
            return stack;
        }
        if (!(op1 instanceof GeoTimeSerie) || !(op2 instanceof Number) || GeoTimeSerie.TYPE.LONG != ((GeoTimeSerie)op1).getType()) throw new WarpScriptException(this.getName() + " can only operate when GTS values and the top stack operand have the same type. Booleans are not supported.");
        GeoTimeSerie gts = (GeoTimeSerie)op1;
        GeoTimeSerie result = gts.cloneEmpty();
        result.setType(GeoTimeSerie.TYPE.LONG);
        if (op2 instanceof Double && Double.isNaN((Double)op2)) {
            stack.push(this.ifOneNaNOperand ? gts.clone() : result);
            return stack;
        } else {
            for (int i = 0; i < GTSHelper.nvalues(gts); ++i) {
                GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), this.operator(EQ.compare((Number)GTSHelper.valueAtIndex(gts, i), (Number)op2), 0) ? GTSHelper.valueAtIndex(gts, i) : null, false);
            }
            if (0 == result.size()) {
                result = result.cloneEmpty();
            }
            stack.push(result);
        }
        return stack;
    }
}

