/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.rexec;

import io.warp10.WarpConfig;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.WebAccessController;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class REXEC
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean compress;
    public static final String WARPSCRIPT_REXEC_ENDPOINT_PATTERNS = "warpscript.rexec.endpoint.patterns";
    private static final String DEFAULT_ENDPOINT_PATTERNS = ".*";
    public static final String WARPSCRIPT_REXEC_CONNECT_TIMEOUT = "warpscript.rexec.timeout.connect";
    private static final String DEFAULT_REXEC_CONNECT_TIMEOUT = "0";
    private int connConnectTimeout;
    public static final String WARPSCRIPT_REXEC_READ_TIMEOUT = "warpscript.rexec.timeout.read";
    private static final String DEFAULT_REXEC_READ_TIMEOUT = "0";
    private int connReadTimeout;
    private final WebAccessController webAccessController;

    public REXEC(String name) {
        this(name, false);
    }

    public REXEC(String name, boolean compress) {
        super(name);
        String patternConf = WarpConfig.getProperty(WARPSCRIPT_REXEC_ENDPOINT_PATTERNS, DEFAULT_ENDPOINT_PATTERNS);
        String readTimeout = WarpConfig.getProperty(WARPSCRIPT_REXEC_READ_TIMEOUT, "0");
        this.connReadTimeout = Integer.parseInt(readTimeout);
        String connectTimeout = WarpConfig.getProperty(WARPSCRIPT_REXEC_CONNECT_TIMEOUT, "0");
        this.connConnectTimeout = Integer.parseInt(connectTimeout);
        this.webAccessController = new WebAccessController(patternConf);
        this.compress = compress;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        String endpoint = stack.pop().toString();
        String warpscript = stack.pop().toString();
        HttpURLConnection conn = null;
        try {
            int len;
            OutputStream connout;
            URL url = new URL(endpoint);
            if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
                throw new WarpScriptException(this.getName() + " invalid endpoint protocol.");
            }
            if (!this.webAccessController.checkURL(url)) {
                throw new WarpScriptException(this.getName() + " encountered a forbidden URL '" + url + "'");
            }
            conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(this.connReadTimeout);
            conn.setConnectTimeout(this.connConnectTimeout);
            conn.setChunkedStreamingMode(8192);
            conn.setRequestProperty("Accept-Encoding", "gzip");
            if (this.compress) {
                conn.setRequestProperty("Content-Type", "application/gzip");
            }
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            OutputStream out = connout = conn.getOutputStream();
            if (this.compress) {
                out = new GZIPOutputStream(out);
            }
            out.write(warpscript.getBytes(StandardCharsets.UTF_8));
            out.write(10);
            out.write("SNAPSHOT".getBytes(StandardCharsets.UTF_8));
            out.write(10);
            out.write("->OPB64".getBytes(StandardCharsets.UTF_8));
            out.write(10);
            if (this.compress) {
                out.close();
            }
            connout.flush();
            if (200 != conn.getResponseCode()) {
                String errorMessage = conn.getHeaderField(Constants.getHeader("http.header.error.message"));
                if (null != errorMessage) {
                    throw new WarpScriptException(this.getName() + " remote execution failed: " + errorMessage);
                }
                throw new WarpScriptException(this.getName() + " remote execution failed with HTTP code " + conn.getResponseCode() + ".'");
            }
            InputStream in = conn.getInputStream();
            if ("gzip".equals(conn.getContentEncoding())) {
                in = new GZIPInputStream(in);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            byte[] bytes = baos.toByteArray();
            String result = new String(bytes, 2, bytes.length - 4, StandardCharsets.US_ASCII);
            stack.push(result);
            stack.exec("OPB64->");
            stack.push(StandardCharsets.UTF_8.name());
            stack.exec("BYTES->");
            stack.exec("EVAL");
        }
        catch (WarpScriptException e) {
            throw e;
        }
        catch (SocketTimeoutException e) {
            throw new WarpScriptException(this.getName() + " Timeout: check configurations " + WARPSCRIPT_REXEC_CONNECT_TIMEOUT + " and " + WARPSCRIPT_REXEC_READ_TIMEOUT, e);
        }
        catch (Exception e) {
            throw new WarpScriptException(e);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return stack;
    }
}

