/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fastdtw;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.fastdtw.DTW;
import io.warp10.script.fastdtw.DistanceFunction;
import io.warp10.script.fastdtw.ExpandedResWindow;
import io.warp10.script.fastdtw.TimeWarpInfo;
import io.warp10.script.fastdtw.WarpPath;

public class FastDTW {
    static final int DEFAULT_SEARCH_RADIUS = 1;

    public static double getWarpDistBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, 1, distFn).getDistance();
    }

    public static double getWarpDistBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, int searchRadius, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius, distFn).getDistance();
    }

    public static WarpPath getWarpPathBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, 1, distFn).getPath();
    }

    public static WarpPath getWarpPathBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, int searchRadius, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius, distFn).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, int searchRadius, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius, distFn);
    }

    private static TimeWarpInfo fastDTW(GeoTimeSerie tsI, GeoTimeSerie tsJ, int searchRadius, DistanceFunction distFn) {
        if (searchRadius < 0) {
            searchRadius = 0;
        }
        int minTSsize = searchRadius + 2;
        if (tsI.size() <= minTSsize || tsJ.size() <= minTSsize) {
            return DTW.getWarpInfoBetween(tsI, tsJ, distFn);
        }
        double resolutionFactor = 2.0;
        GeoTimeSerie shrunkI = null;
        GeoTimeSerie shrunkJ = null;
        ExpandedResWindow window = new ExpandedResWindow(tsI, tsJ, shrunkI, shrunkJ, FastDTW.getWarpPathBetween(shrunkI, shrunkJ, searchRadius, distFn), searchRadius);
        return DTW.getWarpInfoBetween(tsI, tsJ, window, distFn);
    }
}

