/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterByClass
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final String selParam;
    private final Pattern selector;

    public FilterByClass(String name, String selector) {
        super(name);
        this.selParam = selector;
        this.selector = selector.startsWith("=") ? Pattern.compile(Pattern.quote(selector.substring(1))) : (selector.startsWith("~") ? Pattern.compile(selector.substring(1)) : Pattern.compile(Pattern.quote(selector)));
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        Matcher m = this.selector.matcher("");
        for (List<GeoTimeSerie> serie : series) {
            for (GeoTimeSerie gts : serie) {
                if (!m.reset(gts.getName()).matches()) continue;
                retained.add(gts);
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.selParam));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object arg = stack.pop();
            if (!(arg instanceof String)) {
                throw new WarpScriptException("Invalid class selector");
            }
            stack.push(new FilterByClass(this.getName(), (String)arg));
            return stack;
        }
    }
}

