/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.MetadataSelectorMatcher;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilterBySelector
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final String selector;
    private final MetadataSelectorMatcher selectorMatcher;

    public FilterBySelector(String name, String selector) throws WarpScriptException {
        super(name);
        this.selector = selector;
        this.selectorMatcher = new MetadataSelectorMatcher(this.selector);
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> serie : series) {
            for (GeoTimeSerie gts : serie) {
                if (!this.selectorMatcher.matches(gts.getMetadata())) continue;
                retained.add(gts);
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.selector));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object arg = stack.pop();
            if (!(arg instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a STRING selector");
            }
            stack.push(new FilterBySelector(this.getName(), (String)arg));
            return stack;
        }
    }
}

