/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.formatted.FormattedWarpScriptFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilterBySize
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private static final String MIN = "min";
    private static final String MAX = "max";
    private final int min;
    private final int max;

    public FilterBySize(String name, int min, int max) throws WarpScriptException {
        super(name);
        this.min = min;
        this.max = max;
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> serie : series) {
            for (GeoTimeSerie gts : serie) {
                if (gts.size() < this.min || gts.size() > this.max) continue;
                retained.add(gts);
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.min));
        sb.append(" ");
        sb.append(StackUtils.toString(this.max));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends FormattedWarpScriptFunction {
        private final FormattedWarpScriptFunction.Arguments args = new FormattedWarpScriptFunction.ArgumentsBuilder().addArgument(Long.class, "min", "The minimum size.").addArgument(Long.class, "max", "The maximum size.").build();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected FormattedWarpScriptFunction.Arguments getArguments() {
            return this.args;
        }

        @Override
        protected WarpScriptStack apply(Map<String, Object> formattedArgs, WarpScriptStack stack) throws WarpScriptException {
            int min = ((Long)formattedArgs.get(FilterBySize.MIN)).intValue();
            int max = ((Long)formattedArgs.get(FilterBySize.MAX)).intValue();
            stack.push(new FilterBySize(this.getName(), min, max));
            return stack;
        }
    }
}

