/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.formatted;

import io.warp10.WarpConfig;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptStopException;
import io.warp10.script.formatted.ArgumentSpecification;
import io.warp10.script.formatted.DocumentationGenerator;
import io.warp10.script.formatted.FormattedWarpScriptFunction;
import io.warp10.script.functions.TYPEOF;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.BeforeClass;

public class RunAndGenerateDocumentationWithUnitTests {
    protected static final String OUTPUT_FOLDER_KEY = "generated.documentation.output.folder";
    private static final boolean WRITE = false;
    private static final String OUTPUT_FOLDER = "my/output/folder";
    private static final boolean OVERWRITE = false;
    private static String VERSION = "all";
    private static List<String> TAGS = new ArrayList<String>();
    private static boolean MAKE_FUNCTIONS_RELATED_WITHIN_SAME_PACKAGE = true;
    private static List<String> RELATED = new ArrayList<String>();
    private static String SINCE = "2.1";
    private static String DEPRECATED = "";
    private static String DELETED = "";
    private static List<String> CONF = new ArrayList<String>();

    protected boolean WRITE() {
        return false;
    }

    protected String OUTPUT_FOLDER() {
        return WarpConfig.getProperty(OUTPUT_FOLDER_KEY);
    }

    protected boolean OVERWRITE() {
        return false;
    }

    protected String VERSION() {
        return VERSION;
    }

    protected List<String> TAGS() {
        return TAGS;
    }

    protected boolean MAKE_FUNCTIONS_RELATED_WITHIN_SAME_PACKAGE() {
        return MAKE_FUNCTIONS_RELATED_WITHIN_SAME_PACKAGE;
    }

    protected List<String> RELATED() {
        return RELATED;
    }

    protected String SINCE() {
        return SINCE;
    }

    protected String DEPRECATED() {
        return DEPRECATED;
    }

    protected String DELETED() {
        return DELETED;
    }

    protected List<String> CONF() {
        return CONF;
    }

    @BeforeClass
    public static final void beforeClass() throws Exception {
        StringBuilder props = new StringBuilder();
        props.append("warp.timeunits=us");
        WarpConfig.safeSetProperties(new StringReader(props.toString()));
    }

    protected final void generate(List<String> functionNames) throws Exception {
        if (null == this.OUTPUT_FOLDER()) {
            WarpConfig.setProperty(OUTPUT_FOLDER_KEY, OUTPUT_FOLDER);
        }
        MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
        stack.maxLimits();
        stack.exec("INFOMODE");
        Collections.sort(functionNames);
        for (String name : functionNames) {
            Object function = WarpScriptLib.getFunction(name);
            if (!(function instanceof FormattedWarpScriptFunction)) continue;
            String doc = "";
            String mc2 = "";
            System.out.println("Generate and assert doc for " + function.getClass().getName());
            ArrayList<ArgumentSpecification> output = new ArrayList<ArgumentSpecification>();
            Method m = RunAndGenerateDocumentationWithUnitTests.searchMethod(function, "getOutput");
            if (null != m) {
                m.setAccessible(true);
                Object out = m.invoke(function, new Object[0]);
                if (out instanceof FormattedWarpScriptFunction.Arguments) {
                    output = ((FormattedWarpScriptFunction.Arguments)out).getArgsCopy();
                }
            }
            if (0 == output.size()) {
                output.add(new ArgumentSpecification(Object.class, "result", "No documentation provided."));
            }
            ArrayList<String> examples = new ArrayList<String>();
            m = RunAndGenerateDocumentationWithUnitTests.searchMethod(function, "getExamples");
            if (null != m) {
                m.setAccessible(true);
                Object exs = m.invoke(function, new Object[0]);
                if (exs instanceof List) {
                    examples.addAll((List)exs);
                }
            }
            ArrayList<String> tags = new ArrayList<String>(this.TAGS());
            m = RunAndGenerateDocumentationWithUnitTests.searchMethod(function, "getTags");
            if (null != m) {
                m.setAccessible(true);
                Object tag = m.invoke(function, new Object[0]);
                if (tag instanceof List) {
                    tags.addAll((List)tag);
                }
            }
            List<String> related = this.MAKE_FUNCTIONS_RELATED_WITHIN_SAME_PACKAGE() ? RunAndGenerateDocumentationWithUnitTests.getRelatedClasses(function.getClass().getClassLoader(), function.getClass().getPackage().getName()) : this.RELATED();
            related.remove(name);
            m = RunAndGenerateDocumentationWithUnitTests.searchMethod(function, "getRelated");
            if (null != m) {
                m.setAccessible(true);
                Object rel = m.invoke(function, new Object[0]);
                if (rel instanceof List) {
                    for (String r : (List)rel) {
                        if (related.contains(r)) continue;
                        related.add(r);
                    }
                }
            }
            try {
                mc2 = DocumentationGenerator.generateWarpScriptDoc((FormattedWarpScriptFunction)function, this.SINCE(), this.DEPRECATED(), this.DELETED(), this.VERSION(), tags, related, examples, this.CONF(), output);
                boolean caught = false;
                try {
                    stack.execMulti(mc2);
                    stack.exec("EVAL");
                }
                catch (WarpScriptStopException wse) {
                    caught = true;
                    stack.exec("DEPTH");
                    stack.push(1L);
                    stack.exec("==");
                    stack.exec("ASSERT");
                    stack.exec("TYPEOF");
                    stack.push(TYPEOF.typeof(Map.class));
                    stack.exec("==");
                    stack.exec("ASSERT");
                }
                if (!caught) {
                    throw new WarpScriptException("Infomode failed to stop.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.WRITE()) continue;
            String path = this.OUTPUT_FOLDER() + WarpScriptLib.getFunction(name).getClass().getSimpleName().toUpperCase() + ".mc2";
            File file = new File(path);
            if (!this.OVERWRITE() && file.exists()) continue;
            try {
                Files.write(Paths.get(path, new String[0]), mc2.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getRelatedClasses(ClassLoader cl, String pack) throws Exception {
        String dottedPackage = pack.replaceAll("[/]", ".");
        ArrayList<String> classNames = new ArrayList<String>();
        pack = pack.replaceAll("[.]", "/");
        URL upackage = cl.getResource(pack);
        DataInputStream dis = new DataInputStream((InputStream)upackage.getContent());
        String line = null;
        while ((line = dis.readLine()) != null) {
            if (!line.endsWith(".class") || line.contains("$")) continue;
            classNames.add(Class.forName(dottedPackage + "." + line.substring(0, line.lastIndexOf(46))).getSimpleName());
        }
        return classNames;
    }

    public static Method searchMethod(Object function, String simpleName) throws Exception {
        for (Class<?> clazz = function.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(simpleName)) continue;
                return m;
            }
        }
        return null;
    }
}

