/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.UnsafeString;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.FROMTSELEMENTS;
import io.warp10.script.functions.TSELEMENTS;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutablePeriod;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;

public class ADDDURATION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final WarpScriptStackFunction TSELEMENTS = new TSELEMENTS("TSELEMENTS");
    private static final WarpScriptStackFunction FROMTSELEMENTS = new FROMTSELEMENTS("TSELEMENTS->");

    public ADDDURATION(String name) {
        super(name);
    }

    @Override
    public WarpScriptStack apply(WarpScriptStack stack) throws WarpScriptException {
        ReadWritablePeriodWithSubSecondOffset period;
        String duration;
        Object top = stack.pop();
        if (!(top instanceof String) && !(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects an ISO8601 duration (a string) on top of the stack (see http://en.wikipedia.org/wiki/ISO_8601#Durations), or a number of durations (a Long).");
        }
        long N = 1L;
        if (top instanceof String) {
            duration = top.toString();
        } else {
            N = (Long)top;
            top = stack.pop();
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects an ISO8601 duration (a string) in the second level of the stack (see http://en.wikipedia.org/wiki/ISO_8601#Durations).");
            }
            duration = top.toString();
        }
        String tz = null;
        if (stack.peek() instanceof String) {
            tz = stack.pop().toString();
            if (!(stack.peek() instanceof Long)) {
                throw new WarpScriptException(this.getName() + " operates on a tselements list, timestamp, or timestamp and timezone.");
            }
        } else if (!(stack.peek() instanceof List) && !(stack.peek() instanceof Long)) {
            throw new WarpScriptException(this.getName() + " operates on a tselements list, timestamp, or timestamp and timezone.");
        }
        DateTimeZone dtz = DateTimeZone.UTC;
        if (null != tz) {
            dtz = DateTimeZone.forID((String)tz);
        }
        try {
            period = ADDDURATION.durationToPeriod(duration);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " encountered an exception.", wse);
        }
        boolean tselements = false;
        if (stack.peek() instanceof List) {
            FROMTSELEMENTS.apply(stack);
            tselements = true;
        }
        long instant = ((Number)stack.pop()).longValue();
        stack.push(ADDDURATION.addPeriod(instant, period, dtz, N));
        if (tselements) {
            TSELEMENTS.apply(stack);
        }
        return stack;
    }

    public static ReadWritablePeriodWithSubSecondOffset durationToPeriod(String duration) throws WarpScriptException {
        String[] tokens = UnsafeString.split(duration, '.');
        long offset = 0L;
        if (tokens.length > 2) {
            throw new WarpScriptException("Invalid ISO8601 duration");
        }
        if (2 == tokens.length) {
            duration = tokens[0].concat("S");
            String tmp = tokens[1].substring(0, tokens[1].length() - 1);
            try {
                offset = Double.valueOf(Double.parseDouble("0." + tmp) * (double)Constants.TIME_UNITS_PER_S).longValue();
            }
            catch (NumberFormatException e) {
                throw new WarpScriptException("Parsing of sub second precision part of duration has failed. tried to parse: " + tmp);
            }
        }
        MutablePeriod period = new MutablePeriod();
        if (ISOPeriodFormat.standard().getParser().parseInto((ReadWritablePeriod)period, duration, 0, Locale.US) < 0) {
            throw new WarpScriptException("Parsing of duration without sub second precision has failed. Tried to parse: " + duration);
        }
        return new ReadWritablePeriodWithSubSecondOffset((ReadWritablePeriod)period, offset);
    }

    public static long addPeriod(long instant, ReadWritablePeriod period, DateTimeZone dtz) {
        return ADDDURATION.addPeriod(instant, period, dtz, 1L);
    }

    public static long addPeriod(long instant, ReadWritablePeriod period, DateTimeZone dtz, long N) {
        return ADDDURATION.addPeriod(instant, new ReadWritablePeriodWithSubSecondOffset(period, 0L), dtz, N);
    }

    public static long addPeriod(long instant, ReadWritablePeriodWithSubSecondOffset periodAndOffset, DateTimeZone dtz) {
        return ADDDURATION.addPeriod(instant, periodAndOffset, dtz, 1L);
    }

    public static long addPeriod(long instant, ReadWritablePeriodWithSubSecondOffset periodAndOffset, DateTimeZone dtz, long N) {
        long M;
        ReadWritablePeriod period = periodAndOffset.getPeriod();
        long offset = periodAndOffset.getOffset();
        DateTime dt = new DateTime(instant / Constants.TIME_UNITS_PER_MS, dtz);
        for (M = N; M > Integer.MAX_VALUE; M -= Integer.MAX_VALUE) {
            dt = dt.withPeriodAdded((ReadablePeriod)period, Integer.MAX_VALUE);
        }
        while (M < Integer.MIN_VALUE) {
            dt = dt.withPeriodAdded((ReadablePeriod)period, Integer.MIN_VALUE);
            M -= Integer.MIN_VALUE;
        }
        dt = dt.withPeriodAdded((ReadablePeriod)period, Math.toIntExact(M));
        if (period.toPeriod().getSeconds() < 0) {
            offset = -offset;
        }
        long ts = dt.getMillis() * Constants.TIME_UNITS_PER_MS;
        ts += instant % Constants.TIME_UNITS_PER_MS;
        return ts += offset * N;
    }

    public static class ReadWritablePeriodWithSubSecondOffset {
        private final ReadWritablePeriod period;
        private final long offset;

        public ReadWritablePeriodWithSubSecondOffset(ReadWritablePeriod period, long offset) {
            this.period = period;
            this.offset = offset;
        }

        public ReadWritablePeriod getPeriod() {
            return this.period;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

