/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.crypto.CryptoUtils;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Arrays;

public class AESUNWRAP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public AESUNWRAP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " expects a byte array containing a 128, 192 or 256 bits AES key on the stack.");
        }
        byte[] key = (byte[])o;
        if (16 != key.length && 24 != key.length && 32 != key.length) {
            throw new WarpScriptException(this.getName() + " expects a byte array containing a 128, 192 or 256 bits AES key on the stack.");
        }
        o = stack.pop();
        if (!(o instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        byte[] data = (byte[])o;
        byte[] unwrapped = CryptoUtils.unwrap(key, data);
        if (null == unwrapped) {
            throw new WarpScriptException(this.getName() + " encountered undecipherable data.");
        }
        stack.push(Arrays.copyOfRange(unwrapped, 8, unwrapped.length));
        return stack;
    }
}

