/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptATCException;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptReturnException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.UNSECURE;

public class EVALSECURE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public EVALSECURE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.peek();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " can only evaluate a secure script stored as a string.");
        }
        Object exported = stack.getAttribute("exported.symbols");
        stack.setAttribute("exported.symbols", null);
        int debugDepth = (Integer)stack.getAttribute("debug.depth");
        stack.setAttribute("debug.depth", 0);
        boolean secure = Boolean.TRUE.equals(stack.getAttribute("in.secure.macro"));
        stack.setAttribute("in.secure.macro", true);
        boolean allowredefs = Boolean.TRUE.equals(stack.getAttribute("allow.redefined"));
        stack.setAttribute("allow.redefined", false);
        Throwable error = null;
        try {
            new UNSECURE("", false).apply(stack);
            o = stack.pop();
            stack.execMulti(o.toString());
        }
        catch (WarpScriptReturnException ere) {
            if (stack.getCounter(0).decrementAndGet() > 0L) {
                throw ere;
            }
        }
        catch (WarpScriptATCException wsatce) {
            throw wsatce;
        }
        catch (Throwable t) {
            error = t;
            stack.clear();
            throw t;
        }
        finally {
            stack.setAttribute("in.secure.macro", secure);
            stack.setAttribute("allow.redefined", allowredefs);
            if (null == error) {
                stack.setAttribute("debug.depth", debugDepth);
                stack.setAttribute("exported.symbols", exported);
            }
        }
        return stack;
    }
}

