/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.geo.Coverage;
import com.geoxp.geo.CoverageHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class GEOOPTIMIZE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GEOOPTIMIZE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a maximum resolution on top of the stack.");
        }
        int maxres = ((Number)o).intValue();
        if (0 != maxres && (maxres < 2 || maxres > 30 || 0 != (maxres & 1))) {
            throw new WarpScriptException(this.getName() + " expects a maximum resolution which is an even number between 2 and 30 or 0.");
        }
        o = stack.pop();
        if (!(o instanceof GeoXPLib.GeoXPShape)) {
            throw new WarpScriptException(this.getName() + " operates on a shape.");
        }
        GeoXPLib.GeoXPShape shape = (GeoXPLib.GeoXPShape)o;
        if (0 != maxres) {
            shape = GeoXPLib.limitResolution((GeoXPLib.GeoXPShape)shape, (int)maxres, (int)32);
        } else {
            Coverage c = CoverageHelper.fromGeoCells((long[])GeoXPLib.getCells((GeoXPLib.GeoXPShape)shape));
            long thresholds = 0L;
            c.optimize(thresholds);
            shape = GeoXPLib.fromCells((long[])c.toGeoCells(30), (boolean)false);
        }
        stack.push(shape);
        return stack;
    }
}

