/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.List;
import java.util.Map;

public class GET
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GET(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object key = stack.pop();
        Object coll = stack.pop();
        if (!(coll instanceof Map || coll instanceof List || coll instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a map, list or byte array.");
        }
        Object value = null;
        if (coll instanceof Map) {
            value = ((Map)coll).get(key);
        } else if (key instanceof Long) {
            int idx = ((Long)key).intValue();
            if (coll instanceof List) {
                int size = ((List)coll).size();
                idx = GET.computeAndCheckIndex(idx, size);
                value = ((List)coll).get(idx);
            } else {
                int size = ((byte[])coll).length;
                idx = GET.computeAndCheckIndex(idx, size);
                value = (long)((byte[])coll)[idx] & 0xFFL;
            }
        } else {
            if (coll instanceof byte[]) {
                throw new WarpScriptException(this.getName() + " expects the key to be an integer when operating on a byte array.");
            }
            if (!(key instanceof List)) {
                throw new WarpScriptException(this.getName() + " expects the key to be an integer or a list of integers when operating on a List.");
            }
            for (Object o : (List)key) {
                if (o instanceof Long) continue;
                throw new WarpScriptException(this.getName() + " expects the key to be an integer or a list of integers when operating on a List.");
            }
            value = GET.nestedGet((List)coll, (List)key);
        }
        stack.push(value);
        return stack;
    }

    public static int computeAndCheckIndex(int index, int size) throws WarpScriptException {
        if (index < 0) {
            index += size;
        } else if (index >= size) {
            throw new WarpScriptException("Index out of bound, " + index + " >= " + size);
        }
        if (index < 0) {
            throw new WarpScriptException("Index out of bound, " + (index - size) + " < -" + size);
        }
        return index;
    }

    public static Object nestedGet(List<Object> nestedList, List<Long> indexList) throws WarpScriptException {
        Object res = nestedList;
        for (int i = 0; i < indexList.size(); ++i) {
            if (!(res instanceof List)) {
                throw new WarpScriptException("Tried to get an element at a nested path that does not exist in the input list.");
            }
            int idx = GET.computeAndCheckIndex(indexList.get(i).intValue(), res.size());
            res = res.get(idx);
        }
        return res;
    }
}

