/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOutliersHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class HYBRIDTEST2
extends GTSStackFunction {
    private static final String PERIOD_PARAM = "bpp";
    private static final String PERIODS_PER_PIECE_PARAM = "ppp";
    private static final String UPPERBOUND_PARAM = "k";
    private static final String SIGNIFICANCE_PARAM = "alpha";
    private static final double SIGNIFICANCE_DEFAULT = 0.05;

    public HYBRIDTEST2(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object top = stack.pop();
        boolean alpha_is_default = false;
        if (!(top instanceof Double)) {
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a significance level (a DOUBLE) or an upper bound of the number of outliers (a LONG) on top of the stack.");
            }
            alpha_is_default = true;
        }
        if (!alpha_is_default) {
            params.put(SIGNIFICANCE_PARAM, ((Number)top).doubleValue());
            top = stack.pop();
        } else {
            params.put(SIGNIFICANCE_PARAM, 0.05);
        }
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects an upper bound of the number of outliers (a LONG) below the significance level.");
        }
        params.put(UPPERBOUND_PARAM, ((Number)top).intValue());
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of periods per piece (a LONG) below the upper bound of the number of outliers.");
        }
        params.put(PERIODS_PER_PIECE_PARAM, ((Number)top).intValue());
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of buckets per period (a LONG) below the number of periods per piece.");
        }
        params.put(PERIOD_PARAM, ((Number)top).intValue());
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        int bpp = (Integer)params.get(PERIOD_PARAM);
        int ppp = (Integer)params.get(PERIODS_PER_PIECE_PARAM);
        int k = (Integer)params.get(UPPERBOUND_PARAM);
        double alpha = (Double)params.get(SIGNIFICANCE_PARAM);
        if (!GTSHelper.isBucketized(gts) || GTSHelper.nvalues(gts) != GTSHelper.getBucketCount(gts)) {
            throw new WarpScriptException(this.getName() + " operates on bucketized, filled Geo Time Series.");
        }
        return GTSOutliersHelper.entropyHybridTest(gts, bpp, ppp, k, alpha);
    }
}

