/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class MVSPLIT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean bytick;

    public MVSPLIT(String name, boolean bytick) {
        super(name);
        this.bytick = bytick;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        Map renamingMap = new HashMap();
        if (top instanceof Map) {
            renamingMap = (Map)top;
            top = stack.pop();
        }
        HashSet<Long> ticks = new HashSet<Long>();
        ArrayList<Pair> ranges = new ArrayList<Pair>();
        boolean check = false;
        boolean includeZero = false;
        long maxindex = Long.MIN_VALUE;
        if (top instanceof List) {
            boolean gtslist = true;
            for (Object elt : (List)top) {
                if (elt instanceof GeoTimeSerie || elt instanceof GTSEncoder) continue;
                gtslist = false;
                break;
            }
            if (!gtslist) {
                for (Object elt : (List)top) {
                    if (elt instanceof Long) {
                        ticks.add((Long)elt);
                        if (0L == (Long)elt) {
                            includeZero = true;
                        }
                        if ((Long)elt <= maxindex) continue;
                        maxindex = (Long)elt;
                        continue;
                    }
                    if (elt instanceof List) {
                        if (2 != ((List)elt).size()) {
                            throw new WarpScriptException(this.getName() + " expects ticks or ranges of ticks (LONGs).");
                        }
                        if (!(((List)elt).get(0) instanceof Long) || !(((List)elt).get(1) instanceof Long)) {
                            throw new WarpScriptException(this.getName() + " expects ticks or ranges of ticks (LONGs).");
                        }
                        Pair range = Pair.of((Object)((Long)((List)elt).get(0)), (Object)((Long)((List)elt).get(1)));
                        if ((Long)range.getLeft() > (Long)range.getRight()) {
                            range = Pair.of((Object)range.getRight(), (Object)range.getLeft());
                        }
                        ranges.add(range);
                        if ((Long)range.getRight() <= maxindex) continue;
                        maxindex = (Long)range.getRight();
                        continue;
                    }
                    throw new WarpScriptException(this.getName() + " expects ticks or ranges of ticks (LONGs).");
                }
                check = true;
                top = stack.pop();
            }
        } else {
            includeZero = true;
        }
        List inputs = null;
        boolean listinput = false;
        if (top instanceof GTSEncoder || top instanceof GeoTimeSerie) {
            inputs = new ArrayList<Object>(1);
            inputs.add(top);
        } else if (top instanceof List) {
            inputs = (List)top;
            listinput = true;
        } else {
            throw new WarpScriptException(this.getName() + " operates on Geo Time Series\u2122 or ENCODER or a list thereof.");
        }
        TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
        GTSWrapper wrapper = new GTSWrapper();
        HashMap<Long, GTSEncoder> encoders = new HashMap<Long, GTSEncoder>();
        ArrayList outputs = new ArrayList(inputs.size());
        for (Object input : inputs) {
            boolean isencoder = false;
            GTSDecoder decoder = null;
            GeoTimeSerie gts = null;
            if (input instanceof GTSEncoder) {
                isencoder = true;
                decoder = ((GTSEncoder)input).getDecoder(true);
            } else if (input instanceof GeoTimeSerie) {
                isencoder = false;
                gts = (GeoTimeSerie)input;
            } else {
                throw new WarpScriptException(this.getName() + " operates on Geo Time Series\u2122 or ENCODER or a list thereof.");
            }
            encoders.clear();
            try {
                int nvalues;
                int n = nvalues = !isencoder ? GTSHelper.nvalues(gts) : 0;
                block11: for (int idx = 0; isencoder && decoder.next() || !isencoder && idx < nvalues; ++idx) {
                    byte[] bytes2;
                    Object value;
                    long elevation;
                    long location;
                    long ts;
                    if (isencoder) {
                        ts = decoder.getTimestamp();
                        location = decoder.getLocation();
                        elevation = decoder.getElevation();
                        value = decoder.getBinaryValue();
                        if (value instanceof byte[]) {
                            try {
                                wrapper.clear();
                                deser.deserialize((TBase)wrapper, (byte[])value);
                                value = wrapper;
                            }
                            catch (TException tException) {}
                        } else if (value instanceof String) {
                            try {
                                bytes2 = value.toString().getBytes(StandardCharsets.ISO_8859_1);
                                wrapper.clear();
                                deser.deserialize((TBase)wrapper, bytes2);
                                value = wrapper;
                            }
                            catch (TException bytes2) {}
                        }
                    } else {
                        ts = GTSHelper.tickAtIndex(gts, idx);
                        location = GTSHelper.locationAtIndex(gts, idx);
                        elevation = GTSHelper.elevationAtIndex(gts, idx);
                        value = GTSHelper.valueAtIndex(gts, idx);
                        if (value instanceof String) {
                            try {
                                bytes2 = value.toString().getBytes(StandardCharsets.ISO_8859_1);
                                wrapper.clear();
                                deser.deserialize((TBase)wrapper, bytes2);
                                value = wrapper;
                            }
                            catch (TException bytes3) {
                                // empty catch block
                            }
                        }
                    }
                    if (value instanceof GTSWrapper) {
                        GTSDecoder deco = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
                        long index = 0L;
                        while (deco.next()) {
                            long dts = deco.getTimestamp();
                            long dlocation = deco.getLocation();
                            long delevation = deco.getElevation();
                            Object dvalue = deco.getBinaryValue();
                            if (this.bytick) {
                                index = dts;
                            }
                            boolean skip = false;
                            if (check) {
                                skip = true;
                                if (!ticks.isEmpty() && ticks.contains(index)) {
                                    skip = false;
                                }
                                if (skip && !ranges.isEmpty()) {
                                    for (Pair range : ranges) {
                                        if (index < (Long)range.getLeft() || index > (Long)range.getRight()) continue;
                                        skip = false;
                                        break;
                                    }
                                }
                            }
                            if (!skip) {
                                GTSEncoder encoder = (GTSEncoder)encoders.get(index);
                                if (null == encoder) {
                                    encoder = new GTSEncoder(0L);
                                    encoder.setMetadata(null != decoder ? decoder.getMetadata() : gts.getMetadata());
                                    encoders.put(index, encoder);
                                }
                                encoder.addValue(ts, 91480763316633925L != dlocation ? dlocation : location, Long.MIN_VALUE != delevation ? delevation : elevation, dvalue);
                            }
                            if (this.bytick || !check || ++index <= maxindex) continue;
                            continue block11;
                        }
                        continue;
                    }
                    if (!includeZero) continue;
                    GTSEncoder encoder = (GTSEncoder)encoders.get(0L);
                    if (null == encoder) {
                        encoder = new GTSEncoder(0L);
                        encoder.setMetadata(null != decoder ? decoder.getMetadata() : gts.getMetadata());
                        encoders.put(0L, encoder);
                    }
                    encoder.addValue(ts, location, elevation, value);
                }
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " encountered an error while splitting input.");
            }
            GeoTimeSerie g = new GeoTimeSerie();
            for (Map.Entry entry : encoders.entrySet()) {
                Object name = renamingMap.get(entry.getKey());
                if (null == name) {
                    name = renamingMap.get(((Long)entry.getKey()).toString());
                }
                if (null == name) {
                    ((GTSEncoder)entry.getValue()).setName(((GTSEncoder)entry.getValue()).getName() + ":" + entry.getKey());
                    continue;
                }
                g.safeSetMetadata(((GTSEncoder)entry.getValue()).getMetadata());
                GTSHelper.rename(g, name.toString());
            }
            ArrayList results = new ArrayList(encoders.size());
            results.addAll(encoders.values());
            outputs.add(results);
        }
        if (listinput) {
            stack.push(outputs);
        } else {
            stack.push(outputs.get(0));
        }
        return stack;
    }
}

