/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpURLDecoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PARSESELECTOR
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final Pattern EXPR_RE = Pattern.compile("^([^{]+)\\{(.*)\\}$");

    public PARSESELECTOR(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object sel = stack.pop();
        if (!(sel instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a String on top of the stack.");
        }
        try {
            Object[] result = PARSESELECTOR.parse(sel.toString());
            stack.push(result[0]);
            stack.push(result[1]);
        }
        catch (WarpScriptException ee) {
            throw new WarpScriptException(ee);
        }
        return stack;
    }

    public static Object[] parse(String sel) throws WarpScriptException {
        Map<String, String> labelsSelectors;
        Object[] result = new Object[2];
        Matcher m = EXPR_RE.matcher(sel.toString());
        if (!m.matches()) {
            throw new WarpScriptException(" invalid syntax for selector.");
        }
        String classSelector = null;
        try {
            classSelector = WarpURLDecoder.decode(m.group(1), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String labelsSelection = m.group(2);
        try {
            labelsSelectors = GTSHelper.parseLabelsSelectors(labelsSelection);
        }
        catch (ParseException pe) {
            throw new WarpScriptException(pe);
        }
        result[0] = classSelector;
        result[1] = labelsSelectors;
        return result;
    }
}

