/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;

public class PATTERNDETECTION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean standardizePAA;

    public PATTERNDETECTION(String name, boolean standardizePAA) {
        super(name);
        this.standardizePAA = standardizePAA;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a quantization scale on top of the stack.");
        }
        int alphabetSize = ((Number)top).intValue();
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a pattern length at the second level of the stack.");
        }
        int wordLen = ((Number)top).intValue();
        top = stack.pop();
        if (!(top instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a window size at the third level of the stack.");
        }
        int windowLen = ((Number)top).intValue();
        top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of patterns as the fourth level of the stack.");
        }
        List patterns = (List)top;
        top = stack.pop();
        if (top instanceof GeoTimeSerie) {
            stack.push(GTSHelper.detect((GeoTimeSerie)top, alphabetSize, wordLen, windowLen, patterns, this.standardizePAA));
        } else if (top instanceof List) {
            ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
            for (Object o : (List)top) {
                if (!(o instanceof GeoTimeSerie)) {
                    stack.push(top);
                    throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series instances.");
                }
                series.add(GTSHelper.detect((GeoTimeSerie)o, alphabetSize, wordLen, windowLen, patterns, this.standardizePAA));
            }
            stack.push(series);
        } else {
            stack.push(top);
            throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series instances.");
        }
        return stack;
    }
}

