/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class QUATERNIONTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final double PRECISION = 6.103608758678569E-5;

    public QUATERNIONTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object qo = stack.pop();
        if (!(qo instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a quaternion as a LONG on top of the stack.");
        }
        double[] elements = QUATERNIONTO.fromQuaternion(((Number)qo).longValue());
        stack.push(elements[0]);
        stack.push(elements[1]);
        stack.push(elements[2]);
        stack.push(elements[3]);
        return stack;
    }

    public static double[] fromQuaternion(long q) throws WarpScriptException {
        int iz = (int)(q & 0xFFFFL);
        int iy = (int)((q >>>= 16) & 0xFFFFL);
        int ix = (int)((q >>>= 16) & 0xFFFFL);
        int iw = (int)((q >>>= 16) & 0xFFFFL);
        double[] elements = new double[]{2.0 * ((double)iw / 65535.0) - 1.0, 2.0 * ((double)ix / 65535.0) - 1.0, 2.0 * ((double)iy / 65535.0) - 1.0, 2.0 * ((double)iz / 65535.0) - 1.0};
        double norm = elements[0] * elements[0] + elements[1] * elements[1] + elements[2] * elements[2] + elements[3] * elements[3];
        if (Math.abs(1.0 - norm) > 6.103608758678569E-5) {
            throw new WarpScriptException("Input does not appear to be a unit quaternion, norm was " + norm + ".");
        }
        return elements;
    }
}

