/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.geo.Coverage;
import com.geoxp.geo.CoverageHelper;
import com.geoxp.geo.HHCodeHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class TOGEOJSON
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOGEOJSON(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        boolean allCells = false;
        Object top = stack.pop();
        if (top instanceof Boolean) {
            allCells = (Boolean)top;
            top = stack.pop();
        }
        if (!(top instanceof GeoXPLib.GeoXPShape)) {
            throw new WarpScriptException(this.getName() + " operates on a GEOSHAPE.");
        }
        GeoXPLib.GeoXPShape shape = (GeoXPLib.GeoXPShape)top;
        if (allCells) {
            long[] cells = GeoXPLib.getCells((GeoXPLib.GeoXPShape)shape);
            StringBuilder sb = new StringBuilder();
            sb.append("{\"type\":\"MultiPolygon\",\"coordinates\":[");
            String prefix = "";
            for (long cell : cells) {
                int cellRes = (int)(cell >>> 60) << 1;
                long hh = cell << 4;
                double[] bbox = HHCodeHelper.getHHCodeBBox((long)hh, (int)cellRes);
                sb.append(prefix);
                prefix = ",";
                sb.append("[[[").append(bbox[1]).append(",").append(bbox[0]).append("],");
                sb.append("[").append(bbox[3]).append(",").append(bbox[0]).append("],");
                sb.append("[").append(bbox[3]).append(",").append(bbox[2]).append("],");
                sb.append("[").append(bbox[1]).append(",").append(bbox[2]).append("],");
                sb.append("[").append(bbox[1]).append(",").append(bbox[0]).append("]]]");
            }
            sb.append("]}");
            stack.push(sb.toString());
        } else {
            long[] cells = GeoXPLib.getCells((GeoXPLib.GeoXPShape)shape);
            Coverage coverage = new Coverage(cells);
            stack.push(CoverageHelper.toGeoJSON((Coverage)coverage));
        }
        return stack;
    }
}

